/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.crd.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum EventType {
    NORMAL("Normal"),
    WARNING("Warning");

    private final String value;
    private static final Map<String, EventType> CONSTANTS;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static EventType fromValue(String value) {
        EventType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, EventType>();
        for (EventType c : EventType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

