/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.events;

import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class DiscoveryCustomEvent
extends DiscoveryEvent {
    private static final long serialVersionUID = 0L;
    public static final int EVT_DISCOVERY_CUSTOM_EVT = 18;
    private DiscoveryCustomMessage customMsg;
    private AffinityTopologyVersion affTopVer;

    public DiscoveryCustomEvent() {
        this.type(18);
    }

    public DiscoveryCustomMessage customMessage() {
        return this.customMsg;
    }

    public void customMessage(DiscoveryCustomMessage customMsg) {
        this.customMsg = customMsg;
    }

    public AffinityTopologyVersion affinityTopologyVersion() {
        return this.affTopVer;
    }

    public void affinityTopologyVersion(AffinityTopologyVersion affTopVer) {
        this.affTopVer = affTopVer;
    }

    @Override
    public String toString() {
        return S.toString(DiscoveryCustomEvent.class, this, super.toString());
    }

    public static boolean requiresCentralizedAffinityAssignment(DiscoveryEvent evt) {
        if (!(evt instanceof DiscoveryCustomEvent)) {
            return false;
        }
        return DiscoveryCustomEvent.requiresCentralizedAffinityAssignment(((DiscoveryCustomEvent)evt).customMessage());
    }

    public static boolean requiresCentralizedAffinityAssignment(@Nullable DiscoveryCustomMessage msg) {
        if (msg == null) {
            return false;
        }
        if (msg instanceof ChangeGlobalStateMessage && ((ChangeGlobalStateMessage)msg).activate()) {
            return true;
        }
        if (msg instanceof SnapshotDiscoveryMessage) {
            SnapshotDiscoveryMessage snapMsg = (SnapshotDiscoveryMessage)msg;
            return snapMsg.needExchange() && snapMsg.needAssignPartitions();
        }
        if (msg instanceof DynamicCacheChangeBatch) {
            DynamicCacheChangeBatch cacheMsg = (DynamicCacheChangeBatch)msg;
            return cacheMsg.exchangeActions() != null && (!cacheMsg.exchangeActions().cachesToResetLostPartitions().isEmpty() || cacheMsg.exchangeActions().finalizePartitionCounters());
        }
        return false;
    }
}

