/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.plugin.IgniteLogInfoProvider;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;

public class IgniteLogInfoProviderImpl
implements IgniteLogInfoProvider {
    private final DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));

    @Override
    public void ackKernalInited(IgniteLogger log, IgniteConfiguration cfg) {
        assert (log != null);
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        this.ackAsciiLogo(log, cfg, rtBean);
        this.ackConfigUrl(log);
        this.ackConfiguration(log, cfg);
        this.ackOsInfo(log);
        this.ackLanguageRuntime(log, cfg);
        this.ackRemoteManagement(log, cfg);
        this.ackLogger(log);
        this.ackVmArguments(log, cfg, rtBean);
        this.ackClassPaths(log, rtBean);
        this.ackSystemProperties(log);
        this.ackEnvironmentVariables(log);
        this.ackMemoryConfiguration(log, cfg);
        this.ackCacheConfiguration(log, cfg);
        if (cfg.isPeerClassLoadingEnabled()) {
            this.ackP2pConfiguration(log);
        }
        this.ackRebalanceConfiguration(log, cfg);
        this.ackIPv4StackFlagIsSet(log);
        this.ackWaitForBackupsOnShutdownPropertyIsUsed(log);
        this.ack3rdPartyLicenses(log, cfg);
        this.logNodeUserAttributes(log, cfg);
        this.ackSpis(log, cfg);
    }

    @Override
    public void ackNodeBasicMetrics(IgniteLogger log, Ignite ignite) {
        this.ackNodeBasicMetrics(log, (IgniteEx)ignite, this.decimalFormat);
    }

    @Override
    public void ackNodeDataStorageMetrics(IgniteLogger log, Ignite ignite) {
        GridKernalContext ctx = ((IgniteEx)ignite).context();
        this.dataStorageReport(log, ctx.cache().context().database(), this.decimalFormat);
    }

    @Override
    public void ackNodeMemoryStatisticsMetrics(IgniteLogger log, Ignite ignite) {
        GridKernalContext ctx = ((IgniteEx)ignite).context();
        this.memoryStatisticsReport(log, ctx.cache().context().database(), this.decimalFormat);
    }

    @Override
    public void ackKernalStarted(IgniteLogger log, Ignite ignite) {
        IgniteEx igEx = (IgniteEx)ignite;
        this.ackSecurity(log, ignite);
        this.ackPerformanceSuggestions(log, igEx);
        this.ackClassPathContent(log);
        this.ackNodeInfo(log, igEx);
    }

    @Override
    public void ackKernalStopped(IgniteLogger log, Ignite ignite, boolean err) {
        this.ackNodeStopped(log, (IgniteEx)ignite, err);
    }

    void ackAsciiLogo(IgniteLogger log, IgniteConfiguration cfg, RuntimeMXBean rtBean) {
        if (System.getProperty("IGNITE_NO_ASCII") != null) {
            return;
        }
        String ver = "ver. " + IgniteVersionUtils.ACK_VER_STR;
        if (log.isInfoEnabled()) {
            log.info(IgniteKernal.NL + IgniteKernal.NL + ">>>    __________  ________________  " + IgniteKernal.NL + ">>>   /  _/ ___/ |/ /  _/_  __/ __/  " + IgniteKernal.NL + ">>>  _/ // (7 7    // /  / / / _/    " + IgniteKernal.NL + ">>> /___/\\___/_/|_/___/ /_/ /___/   " + IgniteKernal.NL + ">>> " + IgniteKernal.NL + ">>> " + ver + IgniteKernal.NL + ">>> " + IgniteVersionUtils.COPYRIGHT + IgniteKernal.NL + ">>> " + IgniteKernal.NL + ">>> Ignite documentation: https://ignite.apache.org" + IgniteKernal.NL);
        }
        if (log.isQuiet()) {
            U.quiet(false, "   __________  ________________ ", "  /  _/ ___/ |/ /  _/_  __/ __/ ", " _/ // (7 7    // /  / / / _/   ", "/___/\\___/_/|_/___/ /_/ /x___/  ", "", ver, IgniteVersionUtils.COPYRIGHT, "", "Ignite documentation: https://ignite.apache.org", "", "Quiet mode.");
            String fileName = log.fileName();
            if (fileName != null) {
                U.quiet(false, "  ^-- Logging to file '" + fileName + "'");
            }
            U.quiet(false, "  ^-- Logging by '" + ((GridLoggerProxy)log).getLoggerInfo() + "'");
            U.quiet(false, "  ^-- To see **FULL** console log here add -DIGNITE_QUIET=false or \"-v\" to ignite.{sh|bat}", "");
        }
    }

    void ackConfigUrl(IgniteLogger log) {
        if (log.isInfoEnabled()) {
            log.info("Config URL: " + System.getProperty("IGNITE_CONFIG_URL", "n/a"));
        }
    }

    void ackConfiguration(IgniteLogger log, IgniteConfiguration cfg) {
        if (log.isInfoEnabled()) {
            log.info(cfg.toString());
        }
    }

    void ackOsInfo(IgniteLogger log) {
        if (log.isQuiet()) {
            U.quiet(false, "OS: " + U.osString());
        }
        if (log.isInfoEnabled()) {
            log.info("OS: " + U.osString());
            log.info("OS user: " + System.getProperty("user.name"));
            int jvmPid = U.jvmPid();
            log.info("PID: " + (Serializable)(jvmPid == -1 ? "N/A" : Integer.valueOf(jvmPid)));
        }
    }

    void ackLanguageRuntime(IgniteLogger log, IgniteConfiguration cfg) {
        if (log.isQuiet()) {
            U.quiet(false, "VM information: " + U.jdkString());
        }
        if (log.isInfoEnabled()) {
            log.info("Language runtime: " + U.language(U.resolveClassLoader(cfg)));
            log.info("VM information: " + U.jdkString());
            log.info("VM total memory: " + U.heapSize(2) + "GB");
        }
    }

    void ackRemoteManagement(IgniteLogger log, IgniteConfiguration cfg) {
        if (!log.isInfoEnabled()) {
            return;
        }
        SB sb = new SB();
        sb.a("Remote Management [");
        boolean on = U.isJmxRemoteEnabled();
        sb.a("restart: ").a(IgniteLogInfoProviderImpl.onOff(U.isRestartEnabled())).a(", ");
        sb.a("REST: ").a(IgniteLogInfoProviderImpl.onOff(U.isRestEnabled(cfg))).a(", ");
        sb.a("JMX (");
        sb.a("remote: ").a(IgniteLogInfoProviderImpl.onOff(on));
        if (on) {
            sb.a(", ");
            sb.a("port: ").a(System.getProperty("com.sun.management.jmxremote.port", "<n/a>")).a(", ");
            sb.a("auth: ").a(IgniteLogInfoProviderImpl.onOff(Boolean.getBoolean("com.sun.management.jmxremote.authenticate"))).a(", ");
            sb.a("ssl: ").a(IgniteLogInfoProviderImpl.onOff(Boolean.getBoolean("com.sun.management.jmxremote.ssl") || System.getProperty("com.sun.management.jmxremote.ssl") == null));
        }
        sb.a(")");
        sb.a(']');
        log.info(sb.toString());
    }

    void ackLogger(IgniteLogger log) {
        if (log.isInfoEnabled()) {
            log.info("Logger: " + ((GridLoggerProxy)log).getLoggerInfo());
        }
    }

    void ackVmArguments(IgniteLogger log, IgniteConfiguration cfg, RuntimeMXBean rtBean) {
        if (log.isInfoEnabled() && S.includeSensitive()) {
            log.info("IGNITE_HOME=" + cfg.getIgniteHome());
            log.info("VM arguments: " + rtBean.getInputArguments());
        }
    }

    void ackClassPaths(IgniteLogger log, RuntimeMXBean rtBean) {
        if (log.isDebugEnabled()) {
            try {
                log.debug("Boot class path: " + rtBean.getBootClassPath());
                log.debug("Class path: " + rtBean.getClassPath());
                log.debug("Library path: " + rtBean.getLibraryPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void ackSystemProperties(IgniteLogger log) {
        if (log.isDebugEnabled() && S.includeSensitive()) {
            for (Map.Entry<Object, Object> entry : IgniteSystemProperties.snapshot().entrySet()) {
                log.debug("System property [" + entry.getKey() + "=" + entry.getValue() + "]");
            }
        }
    }

    void ackEnvironmentVariables(IgniteLogger log) {
        if (log.isDebugEnabled()) {
            for (Map.Entry<String, String> envVar : System.getenv().entrySet()) {
                log.debug("Environment variable [" + envVar.getKey() + "=" + envVar.getValue() + "]");
            }
        }
    }

    void ackMemoryConfiguration(IgniteLogger log, IgniteConfiguration cfg) {
        DataStorageConfiguration memCfg = cfg.getDataStorageConfiguration();
        if (memCfg == null) {
            return;
        }
        U.log(log, "System cache's DataRegion size is configured to " + memCfg.getSystemDataRegionConfiguration().getInitialSize() / 0x100000L + " MB. Use DataStorageConfiguration.systemRegionInitialSize property to change the setting.");
    }

    void ackCacheConfiguration(IgniteLogger log, IgniteConfiguration cfg) {
        CacheConfiguration[] cacheCfgs = cfg.getCacheConfiguration();
        if (cacheCfgs == null || cacheCfgs.length == 0) {
            U.warn(log, "Cache is not configured - in-memory data grid is off.");
        } else {
            SB sb = new SB();
            HashMap memPlcNamesMapping = new HashMap();
            for (CacheConfiguration c : cacheCfgs) {
                String cacheName = U.maskName(c.getName());
                String memPlcName = c.getDataRegionName();
                if (CU.isSystemCache(cacheName)) {
                    memPlcName = "sysMemPlc";
                } else if (memPlcName == null && cfg.getDataStorageConfiguration() != null) {
                    memPlcName = cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().getName();
                }
                if (!memPlcNamesMapping.containsKey(memPlcName)) {
                    memPlcNamesMapping.put(memPlcName, new ArrayList());
                }
                ArrayList cacheNames = (ArrayList)memPlcNamesMapping.get(memPlcName);
                cacheNames.add(cacheName);
            }
            for (Map.Entry entry : memPlcNamesMapping.entrySet()) {
                sb.a("in '").a((String)entry.getKey()).a("' dataRegion: [");
                for (String s : (ArrayList)entry.getValue()) {
                    sb.a("'").a(s).a("', ");
                }
                sb.d(sb.length() - 2, sb.length()).a("], ");
            }
            U.log(log, "Configured caches [" + sb.d(sb.length() - 2, sb.length()).toString() + "]");
        }
    }

    void ackP2pConfiguration(IgniteLogger log) {
        U.warn(log, "Peer class loading is enabled (disable it in production for performance and deployment consistency reasons)");
    }

    void ackRebalanceConfiguration(IgniteLogger log, IgniteConfiguration cfg) {
        if (cfg.isClientMode().booleanValue()) {
            if (cfg.getRebalanceThreadPoolSize() != IgniteConfiguration.DFLT_REBALANCE_THREAD_POOL_SIZE) {
                U.warn(log, "Setting the rebalance pool size has no effect on the client mode");
            }
        } else {
            if (cfg.getRebalanceThreadPoolSize() < 1) {
                throw new IgniteException("Rebalance thread pool size minimal allowed value is 1. Change IgniteConfiguration.rebalanceThreadPoolSize property before next start.");
            }
            if (cfg.getRebalanceBatchesPrefetchCount() < 1L) {
                throw new IgniteException("Rebalance batches prefetch count minimal allowed value is 1. Change IgniteConfiguration.rebalanceBatchesPrefetchCount property before next start.");
            }
            if (cfg.getRebalanceBatchSize() <= 0) {
                throw new IgniteException("Rebalance batch size must be greater than zero. Change IgniteConfiguration.rebalanceBatchSize property before next start.");
            }
            if (cfg.getRebalanceThrottle() < 0L) {
                throw new IgniteException("Rebalance throttle can't have negative value. Change IgniteConfiguration.rebalanceThrottle property before next start.");
            }
            if (cfg.getRebalanceTimeout() < 0L) {
                throw new IgniteException("Rebalance message timeout can't have negative value. Change IgniteConfiguration.rebalanceTimeout property before next start.");
            }
            for (CacheConfiguration ccfg : cfg.getCacheConfiguration()) {
                if (ccfg.getRebalanceBatchesPrefetchCount() >= 1L) continue;
                throw new IgniteException("Rebalance batches prefetch count minimal allowed value is 1. Change CacheConfiguration.rebalanceBatchesPrefetchCount property before next start. [cache=" + ccfg.getName() + "]");
            }
        }
    }

    void ackIPv4StackFlagIsSet(IgniteLogger log) {
        boolean preferIPv4 = Boolean.parseBoolean(System.getProperty("java.net.preferIPv4Stack"));
        if (!preferIPv4) {
            U.quietAndWarn(log, "Please set system property '-Djava.net.preferIPv4Stack=true' to avoid possible problems in mixed environments.");
        }
    }

    void ackWaitForBackupsOnShutdownPropertyIsUsed(IgniteLogger log) {
        if (IgniteSystemProperties.getString("IGNITE_WAIT_FOR_BACKUPS_ON_SHUTDOWN") == null) {
            return;
        }
        log.warning("IGNITE_WAIT_FOR_BACKUPS_ON_SHUTDOWN system property is deprecated and will be removed in a future version. Use ShutdownPolicy instead.");
    }

    void ack3rdPartyLicenses(IgniteLogger log, IgniteConfiguration cfg) {
        if (log.isInfoEnabled() && cfg.getIgniteHome() != null) {
            log.info("3-rd party licenses can be found at: " + cfg.getIgniteHome() + File.separatorChar + "libs" + File.separatorChar + "licenses");
        }
    }

    void logNodeUserAttributes(IgniteLogger log, IgniteConfiguration cfg) {
        if (log.isInfoEnabled()) {
            for (Map.Entry<String, ?> attr : cfg.getUserAttributes().entrySet()) {
                log.info("Local node user attribute [" + attr.getKey() + "=" + attr.getValue() + "]");
            }
        }
    }

    void ackSpis(IgniteLogger log, IgniteConfiguration cfg) {
        if (log.isDebugEnabled()) {
            log.debug("+-------------+");
            log.debug("START SPI LIST:");
            log.debug("+-------------+");
            log.debug("Grid checkpoint SPI       : " + Arrays.toString(cfg.getCheckpointSpi()));
            log.debug("Grid collision SPI        : " + cfg.getCollisionSpi());
            log.debug("Grid communication SPI    : " + cfg.getCommunicationSpi());
            log.debug("Grid deployment SPI       : " + cfg.getDeploymentSpi());
            log.debug("Grid discovery SPI        : " + cfg.getDiscoverySpi());
            log.debug("Grid event storage SPI    : " + cfg.getEventStorageSpi());
            log.debug("Grid failover SPI         : " + Arrays.toString(cfg.getFailoverSpi()));
            log.debug("Grid load balancing SPI   : " + Arrays.toString(cfg.getLoadBalancingSpi()));
            log.debug("Grid Metrics Exporter SPI : " + Arrays.toString(cfg.getMetricExporterSpi()));
        }
    }

    void ackPerformanceSuggestions(IgniteLogger log, IgniteEx ignite) {
        GridKernalContext ctx = ignite.context();
        ctx.performance().add("Disable assertions (remove '-ea' from JVM options)", !U.assertionsEnabled());
        ctx.performance().logSuggestions(log, ignite.name());
    }

    void ackClassPathContent(IgniteLogger log) {
        if (IgniteSystemProperties.getBoolean("IGNITE_QUIET", true)) {
            return;
        }
        boolean enabled = IgniteSystemProperties.getBoolean("IGNITE_LOG_CLASSPATH_CONTENT_ON_STARTUP", true);
        if (enabled) {
            String clsPath = System.getProperty("java.class.path", ".");
            String[] clsPathElements = clsPath.split(File.pathSeparator);
            U.log(log, "Classpath value: " + clsPath);
            SB clsPathContent = new SB("List of files containing in classpath: ");
            for (String clsPathEntry : clsPathElements) {
                try {
                    if (clsPathEntry.contains("*")) {
                        this.ackClassPathWildCard(clsPathEntry, clsPathContent);
                        continue;
                    }
                    this.ackClassPathEntry(clsPathEntry, clsPathContent);
                }
                catch (Exception e) {
                    U.warn(log, String.format("Could not log class path entry '%s': %s", clsPathEntry, e.getMessage()));
                }
            }
            U.log(log, clsPathContent.toString());
        }
    }

    void ackClassPathWildCard(String clsPathEntry, SB clsPathContent) {
        int lastSeparatorIdx = clsPathEntry.lastIndexOf(File.separator);
        int asteriskIdx = clsPathEntry.indexOf(42);
        if (asteriskIdx >= 0 && asteriskIdx < lastSeparatorIdx) {
            throw new RuntimeException("Could not parse classpath entry");
        }
        int fileMaskFirstIdx = lastSeparatorIdx + 1;
        String fileMask = fileMaskFirstIdx >= clsPathEntry.length() ? "*.jar" : clsPathEntry.substring(fileMaskFirstIdx);
        Path path = Paths.get(lastSeparatorIdx > 0 ? clsPathEntry.substring(0, lastSeparatorIdx) : ".", new String[0]).toAbsolutePath().normalize();
        if (lastSeparatorIdx == 0) {
            path = path.getRoot();
        }
        try {
            DirectoryStream<Path> files = Files.newDirectoryStream(path, fileMask);
            for (Path f : files) {
                String s = f.toString();
                if (!s.toLowerCase().endsWith(".jar")) continue;
                clsPathContent.a(f.toString()).a(";");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void ackClassPathEntry(String clsPathEntry, SB clsPathContent) {
        File clsPathElementFile = new File(clsPathEntry);
        if (clsPathElementFile.isDirectory()) {
            clsPathContent.a(clsPathEntry).a(";");
        } else {
            String extension;
            String string = extension = clsPathEntry.length() >= 4 ? clsPathEntry.substring(clsPathEntry.length() - 4).toLowerCase() : null;
            if (".jar".equals(extension) || ".zip".equals(extension)) {
                clsPathContent.a(clsPathEntry).a(";");
            }
        }
    }

    void ackNodeInfo(IgniteLogger log, IgniteEx ignite) {
        ClusterNode locNode = ignite.localNode();
        GridKernalContext ctx = ignite.context();
        if (log.isQuiet()) {
            U.quiet(false, "");
            U.quiet(false, "Ignite node started OK (id=" + U.id8(locNode.id()) + (String)(F.isEmpty(ignite.name()) ? "" : ", instance name=" + ignite.name()) + ")");
        }
        if (log.isInfoEnabled()) {
            String ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + "#" + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR;
            String dash = U.dash(ack.length());
            SB sb = new SB();
            for (GridPortRecord rec : ctx.ports().records()) {
                sb.a((Object)rec.protocol()).a(":").a(rec.port()).a(" ");
            }
            String str = IgniteKernal.NL + IgniteKernal.NL + ">>> " + dash + IgniteKernal.NL + ">>> " + ack + IgniteKernal.NL + ">>> " + dash + IgniteKernal.NL + ">>> OS name: " + U.osString() + IgniteKernal.NL + ">>> CPU(s): " + locNode.metrics().getTotalCpus() + IgniteKernal.NL + ">>> Heap: " + U.heapSize(locNode, 2) + "GB" + IgniteKernal.NL + ">>> VM name: " + ((IgniteKernal)ignite).vmName() + IgniteKernal.NL + (String)(ignite.name() == null ? "" : ">>> Ignite instance name: " + ignite.name() + IgniteKernal.NL) + ">>> Local node [ID=" + locNode.id().toString().toUpperCase() + ", order=" + locNode.order() + ", clientMode=" + ctx.clientNode() + "]" + IgniteKernal.NL + ">>> Local node addresses: " + U.addressesAsString(locNode) + IgniteKernal.NL + ">>> Local ports: " + sb + IgniteKernal.NL + ">>> " + dash + IgniteKernal.NL;
            log.info(str);
        }
        if (ctx.state().clusterState().state() == ClusterState.INACTIVE) {
            U.quietAndInfo(log, ">>> Ignite cluster is in INACTIVE state (limited functionality available). Use control.(sh|bat) script or IgniteCluster.state(ClusterState.ACTIVE) to change the state.");
        }
    }

    void ackNodeBasicMetrics(IgniteLogger log, IgniteEx ignite, DecimalFormat dblFmt) {
        if (!log.isInfoEnabled()) {
            return;
        }
        GridKernalContext ctx = ignite.context();
        IgniteConfiguration cfg = ignite.configuration();
        ExecutorService execSvc = ctx.pools().getExecutorService();
        ExecutorService sysExecSvc = ctx.pools().getSystemExecutorService();
        ExecutorService qryExecSvc = ctx.pools().getQueryExecutorService();
        StripedExecutor stripedExecSvc = ctx.pools().getStripedExecutorService();
        Map<String, ? extends ExecutorService> customExecSvcs = ctx.pools().customExecutors();
        ClusterMetrics m = ignite.cluster().localNode().metrics();
        int locCpus = m.getTotalCpus();
        double cpuLoadPct = m.getCurrentCpuLoad() * 100.0;
        double avgCpuLoadPct = m.getAverageCpuLoad() * 100.0;
        double gcPct = m.getCurrentGcCpuLoad() * 100.0;
        long heapUsed = m.getHeapMemoryUsed();
        long heapMax = m.getHeapMemoryMaximum();
        long heapUsedInMBytes = heapUsed / 0x100000L;
        long heapCommInMBytes = m.getHeapMemoryCommitted() / 0x100000L;
        double freeHeapPct = heapMax > 0L ? (double)((heapMax - heapUsed) * 100L) / (double)heapMax : -1.0;
        int hosts = 0;
        int servers = 0;
        int clients = 0;
        int cpus = 0;
        try {
            ClusterMetrics metrics = ignite.cluster().metrics();
            Collection<ClusterNode> nodes0 = ignite.cluster().nodes();
            hosts = U.neighborhood(nodes0).size();
            servers = ignite.cluster().forServers().nodes().size();
            clients = ignite.cluster().forClients().nodes().size();
            cpus = metrics.getTotalCpus();
        }
        catch (IgniteException metrics) {
            // empty catch block
        }
        String id = U.id8(ignite.localNode().id());
        AffinityTopologyVersion topVer = ctx.discovery().topologyVersionEx();
        ClusterNode locNode = ctx.discovery().localNode();
        Object netDetails = "";
        if (!F.isEmpty(cfg.getLocalHost())) {
            netDetails = (String)netDetails + ", localHost=" + cfg.getLocalHost();
        }
        if (locNode instanceof TcpDiscoveryNode) {
            netDetails = (String)netDetails + ", discoPort=" + ((TcpDiscoveryNode)locNode).discoveryPort();
        }
        if (cfg.getCommunicationSpi() instanceof TcpCommunicationSpi) {
            netDetails = (String)netDetails + ", commPort=" + ((TcpCommunicationSpi)cfg.getCommunicationSpi()).boundPort();
        }
        SB msg = new SB();
        msg.nl().a("Metrics for local node (to disable set 'metricsLogFrequency' to 0)").nl().a("    ^-- Node [id=").a(id).a((String)(ignite.name() != null ? ", name=" + ignite.name() : "")).a(", uptime=").a(((IgniteKernal)ignite).upTimeFormatted()).a("]").nl().a("    ^-- Cluster [hosts=").a(hosts).a(", CPUs=").a(cpus).a(", servers=").a(servers).a(", clients=").a(clients).a(", topVer=").a(topVer.topologyVersion()).a(", minorTopVer=").a(topVer.minorTopologyVersion()).a("]").nl().a("    ^-- Network [addrs=").a(locNode.addresses()).a((String)netDetails).a("]").nl().a("    ^-- CPU [CPUs=").a(locCpus).a(", curLoad=").a(dblFmt.format(cpuLoadPct)).a("%, avgLoad=").a(dblFmt.format(avgCpuLoadPct)).a("%, GC=").a(dblFmt.format(gcPct)).a("%]").nl().a("    ^-- Heap [used=").a(dblFmt.format(heapUsedInMBytes)).a("MB, free=").a(dblFmt.format(freeHeapPct)).a("%, comm=").a(dblFmt.format(heapCommInMBytes)).a("MB]").nl().a("    ^-- Outbound messages queue [size=").a(m.getOutboundMessagesQueueSize()).a("]").nl().a("    ^-- ").a(this.createExecutorDescription("Public thread pool", execSvc)).nl().a("    ^-- ").a(this.createExecutorDescription("System thread pool", sysExecSvc)).nl().a("    ^-- ").a(this.createExecutorDescription("Query thread pool", qryExecSvc)).nl().a("    ^-- ").a(this.createExecutorDescription("Striped thread pool", stripedExecSvc));
        if (customExecSvcs != null) {
            for (Map.Entry<String, ? extends ExecutorService> entry : customExecSvcs.entrySet()) {
                msg.nl().a("    ^-- ").a(this.createExecutorDescription(entry.getKey(), entry.getValue()));
            }
        }
        log.info(msg.toString());
        ctx.cache().context().database().dumpStatistics(log);
    }

    String createExecutorDescription(String execSvcName, ExecutorService execSvc) {
        ExecutorService exec;
        int poolSize = 0;
        int poolActiveThreads = 0;
        int poolQSize = 0;
        if (execSvc instanceof ThreadPoolExecutor) {
            exec = (ThreadPoolExecutor)execSvc;
            poolSize = ((ThreadPoolExecutor)exec).getPoolSize();
            poolActiveThreads = Math.min(poolSize, ((ThreadPoolExecutor)exec).getActiveCount());
            poolQSize = ((ThreadPoolExecutor)exec).getQueue().size();
        } else if (execSvc instanceof StripedExecutor) {
            exec = (StripedExecutor)execSvc;
            poolSize = ((StripedExecutor)exec).stripesCount();
            poolActiveThreads = ((StripedExecutor)exec).activeStripesCount();
            poolQSize = ((StripedExecutor)exec).queueSize();
        }
        int poolIdleThreads = poolSize - poolActiveThreads;
        return execSvcName + " [active=" + poolActiveThreads + ", idle=" + poolIdleThreads + ", qSize=" + poolQSize + "]";
    }

    void dataStorageReport(IgniteLogger log, IgniteCacheDatabaseSharedManager db, DecimalFormat dblFmt) {
        if (F.isEmpty(db.dataRegions())) {
            return;
        }
        SB dataRegionsInfo = new SB();
        dataRegionsInfo.nl();
        for (DataRegion region : db.dataRegions()) {
            DataRegionConfiguration regCfg = region.config();
            long pagesCnt = region.pageMemory().loadedPages();
            long offHeapUsed = (long)region.pageMemory().systemPageSize() * pagesCnt;
            long offHeapInit = regCfg.getInitialSize();
            long offHeapMax = regCfg.getMaxSize();
            long offHeapComm = region.metrics().getOffHeapSize();
            long offHeapUsedInMBytes = offHeapUsed / 0x100000L;
            long offHeapMaxInMBytes = offHeapMax / 0x100000L;
            long offHeapCommInMBytes = offHeapComm / 0x100000L;
            long offHeapInitInMBytes = offHeapInit / 0x100000L;
            double freeOffHeapPct = offHeapMax > 0L ? (double)((offHeapMax - offHeapUsed) * 100L) / (double)offHeapMax : -1.0;
            String type = "user";
            try {
                if (region == db.dataRegion(null)) {
                    type = "default";
                } else if (IgniteCacheDatabaseSharedManager.INTERNAL_DATA_REGION_NAMES.contains(regCfg.getName())) {
                    type = "internal";
                }
            }
            catch (IgniteCheckedException ice) {
                ice.printStackTrace();
            }
            dataRegionsInfo.a("    ^--   ").a(regCfg.getName()).a(" region [type=").a(type).a(", persistence=").a(regCfg.isPersistenceEnabled()).a(", lazyAlloc=").a(regCfg.isLazyMemoryAllocation()).a(',').nl().a("      ...  ").a("initCfg=").a(dblFmt.format(offHeapInitInMBytes)).a("MB, maxCfg=").a(dblFmt.format(offHeapMaxInMBytes)).a("MB, usedRam=").a(dblFmt.format(offHeapUsedInMBytes)).a("MB, freeRam=").a(dblFmt.format(freeOffHeapPct)).a("%, allocRam=").a(dblFmt.format(offHeapCommInMBytes)).a("MB");
            if (regCfg.isPersistenceEnabled()) {
                dataRegionsInfo.a(", allocTotal=").a(dblFmt.format(region.metrics().getTotalAllocatedSize() / 0x100000L)).a("MB");
            }
            dataRegionsInfo.a(']').nl();
        }
        if (log.isQuiet()) {
            U.quietMultipleLines(false, dataRegionsInfo.toString());
        } else if (log.isInfoEnabled()) {
            log.info(dataRegionsInfo.toString());
        }
    }

    void memoryStatisticsReport(IgniteLogger log, IgniteCacheDatabaseSharedManager db, DecimalFormat dblFmt) {
        if (F.isEmpty(db.dataRegions())) {
            return;
        }
        SB sb = new SB();
        sb.nl();
        long loadedPages = 0L;
        long offHeapUsedSummary = 0L;
        long offHeapMaxSummary = 0L;
        long offHeapCommSummary = 0L;
        long pdsUsedSummary = 0L;
        boolean persistenceEnabled = false;
        for (DataRegion region : db.dataRegions()) {
            DataRegionConfiguration regCfg = region.config();
            long pagesCnt = region.pageMemory().loadedPages();
            long offHeapUsed = (long)region.pageMemory().systemPageSize() * pagesCnt;
            long offHeapMax = regCfg.getMaxSize();
            long offHeapComm = region.metrics().getOffHeapSize();
            offHeapUsedSummary += offHeapUsed;
            offHeapMaxSummary += offHeapMax;
            offHeapCommSummary += offHeapComm;
            loadedPages += pagesCnt;
            if (!regCfg.isPersistenceEnabled()) continue;
            pdsUsedSummary += region.metrics().getTotalAllocatedSize();
            persistenceEnabled = true;
        }
        double freeOffHeapPct = offHeapMaxSummary > 0L ? (double)((offHeapMaxSummary - offHeapUsedSummary) * 100L) / (double)offHeapMaxSummary : -1.0;
        sb.nl().a("Data storage metrics for local node (to disable set 'metricsLogFrequency' to 0)").nl().a("    ^-- Off-heap memory [used=").a(dblFmt.format(offHeapUsedSummary / 0x100000L)).a("MB, free=").a(dblFmt.format(freeOffHeapPct)).a("%, allocated=").a(dblFmt.format(offHeapCommSummary / 0x100000L)).a("MB]").nl().a("    ^-- Page memory [pages=").a(loadedPages).a("]").nl();
        if (persistenceEnabled) {
            sb.a("    ^-- Ignite persistence [used=").a(dblFmt.format(pdsUsedSummary / 0x100000L)).a("MB]").nl();
        }
        if (log.isQuiet()) {
            U.quietMultipleLines(false, sb.toString());
        } else if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
    }

    void ackNodeStopped(IgniteLogger log, IgniteEx ignite, boolean err) {
        String ack;
        String igniteInstanceName = ignite.name();
        if (log.isQuiet()) {
            Object nodeName;
            Object object = nodeName = igniteInstanceName == null ? "" : "name=" + igniteInstanceName + ", ";
            if (!err) {
                U.quiet(false, "Ignite node stopped OK [" + (String)nodeName + "uptime=" + ((IgniteKernal)ignite).upTimeFormatted() + "]");
            } else {
                U.quiet(true, "Ignite node stopped wih ERRORS [" + (String)nodeName + "uptime=" + ((IgniteKernal)ignite).upTimeFormatted() + "]");
            }
        }
        if (!log.isInfoEnabled()) {
            return;
        }
        if (!err) {
            ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + "#" + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR + " stopped OK";
            String dash = U.dash(ack.length());
            log.info(IgniteKernal.NL + IgniteKernal.NL + ">>> " + dash + IgniteKernal.NL + ">>> " + ack + IgniteKernal.NL + ">>> " + dash + IgniteKernal.NL + (String)(igniteInstanceName == null ? "" : ">>> Ignite instance name: " + igniteInstanceName + IgniteKernal.NL) + ">>> Grid uptime: " + ((IgniteKernal)ignite).upTimeFormatted() + IgniteKernal.NL + IgniteKernal.NL);
        } else {
            ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + "#" + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR + " stopped with ERRORS";
            String dash = U.dash(ack.length());
            log.info(IgniteKernal.NL + IgniteKernal.NL + ">>> " + ack + IgniteKernal.NL + ">>> " + dash + IgniteKernal.NL + (String)(igniteInstanceName == null ? "" : ">>> Ignite instance name: " + igniteInstanceName + IgniteKernal.NL) + ">>> Grid uptime: " + ((IgniteKernal)ignite).upTimeFormatted() + IgniteKernal.NL + ">>> See log above for detailed error message." + IgniteKernal.NL + ">>> Note that some errors during stop can prevent grid from" + IgniteKernal.NL + ">>> maintaining correct topology since this node may have" + IgniteKernal.NL + ">>> not exited grid properly." + IgniteKernal.NL + IgniteKernal.NL);
        }
    }

    void ackSecurity(IgniteLogger log, Ignite ignite) {
        assert (log != null);
        GridKernalContext ctx = ((IgniteEx)ignite).context();
        U.quietAndInfo(log, "Security status [authentication=" + IgniteLogInfoProviderImpl.onOff(ctx.security().enabled()) + ", sandbox=" + IgniteLogInfoProviderImpl.onOff(ctx.security().sandbox().enabled()) + ", tls/ssl=" + IgniteLogInfoProviderImpl.onOff(ctx.config().getSslContextFactory() != null) + "]");
    }

    public static String onOff(boolean b) {
        return b ? "on" : "off";
    }
}

