/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;

public class DmlDistributedUpdateRun {
    private final int nodeCount;
    private final HashSet<UUID> rspNodes;
    private long updCntr = 0L;
    private HashSet<Object> errorKeys;
    private final GridFutureAdapter<UpdateResult> fut = new GridFutureAdapter();

    public DmlDistributedUpdateRun(int nodeCount) {
        this.nodeCount = nodeCount;
        this.rspNodes = new HashSet(nodeCount);
    }

    public GridFutureAdapter<UpdateResult> future() {
        return this.fut;
    }

    public void handleDisconnect(CacheException e) {
        this.fut.onDone((Throwable)new IgniteCheckedException("Update failed because client node have disconnected.", (Throwable)e));
    }

    public void handleNodeLeft(UUID nodeId) {
        this.fut.onDone((Throwable)new IgniteCheckedException("Update failed because map node left topology [nodeId=" + nodeId + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(UUID id, GridH2DmlResponse msg) {
        DmlDistributedUpdateRun dmlDistributedUpdateRun = this;
        synchronized (dmlDistributedUpdateRun) {
            if (!this.rspNodes.add(id)) {
                return;
            }
            String err = msg.error();
            if (err != null) {
                this.fut.onDone((Throwable)new IgniteCheckedException("Update failed. " + (F.isEmpty((String)err) ? "" : err) + "[reqId=" + msg.requestId() + ", node=" + id + "]."));
                return;
            }
            if (!F.isEmpty((Object[])msg.errorKeys())) {
                List<Object> errList = Arrays.asList(msg.errorKeys());
                if (this.errorKeys == null) {
                    this.errorKeys = new HashSet<Object>(errList);
                } else {
                    this.errorKeys.addAll(errList);
                }
            }
            this.updCntr += msg.updateCounter();
            if (this.rspNodes.size() == this.nodeCount) {
                this.fut.onDone((Object)new UpdateResult(this.updCntr, this.errorKeys == null ? null : this.errorKeys.toArray()));
            }
        }
    }
}

