/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.meta;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.util.typedef.internal.U;

public class MetaUpdateCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Argument(example="<fileName>")
    private String in;
    private byte[] metaMarshalled;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.in);
        U.writeByteArray(out, this.metaMarshalled);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.in = U.readString(in);
        this.metaMarshalled = U.readByteArray(in);
    }

    public byte[] metaMarshalled() {
        return this.metaMarshalled;
    }

    public void metaMarshalled(byte[] metaMarshalled) {
        this.metaMarshalled = metaMarshalled;
    }

    public String in() {
        return this.in;
    }

    public void in(String in) {
        Path inFile = FileSystems.getDefault().getPath(in, new String[0]);
        try (InputStream is = Files.newInputStream(inFile, new OpenOption[0]);){
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            U.copy(is, buf);
            this.metaMarshalled = buf.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read metadata from " + inFile, e);
        }
        this.in = in;
    }
}

