/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.io.Serializable;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ignite.internal.client.HostAndPortRange;
import org.apache.ignite.internal.jdbc.ConnectionProperties;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class ConnectionPropertiesImpl
implements ConnectionProperties,
Serializable {
    public static final String URL_PREFIX = "jdbc:ignite:thin://";
    private static final long serialVersionUID = 0L;
    public static final String PROP_PREFIX = "ignite.jdbc.";
    private static final String PROP_SCHEMA = "schema";
    private String url;
    private HostAndPortRange[] addrs;
    private final StringProperty schema = new StringProperty("schema", "Schema name of the connection", "PUBLIC", null, false, null);
    private final IntegerProperty qryTimeout = new IntegerProperty("queryTimeout", "Sets the number of seconds the driver will wait for a <code>Statement</code> object to execute. Zero means there is no limits.", null, false, 0, Integer.MAX_VALUE);
    private final IntegerProperty connTimeout = new IntegerProperty("connectionTimeout", "Sets the number of milliseconds JDBC client will waits for server to response. Zero means there is no limits.", (Number)0L, false, 0, Integer.MAX_VALUE);
    private final LongProperty reconnectThrottlingPeriod = new LongProperty("reconnectThrottlingPeriod", "Sets the reconnect throttling period, in milliseconds. Zero means there is no limits.", (Number)30000L, false, 0L, Long.MAX_VALUE);
    private final IntegerProperty reconnectThrottlingRetries = new IntegerProperty("reconnectThrottlingRetries", "Sets the reconnect throttling retries. Zero means there is no limits.", (Number)3, false, 0, Integer.MAX_VALUE);
    private final ConnectionProperty[] propsArray = new ConnectionProperty[]{this.qryTimeout, this.connTimeout};

    @Override
    public String getSchema() {
        return this.schema.value();
    }

    @Override
    public void setSchema(String schema) {
        this.schema.setValue(schema);
    }

    @Override
    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        if (ArrayUtils.nullOrEmpty((Object[])this.getAddresses())) {
            return null;
        }
        StringBuilder sbUrl = new StringBuilder(URL_PREFIX);
        HostAndPortRange[] addrs = this.getAddresses();
        for (int i = 0; i < addrs.length; ++i) {
            if (i > 0) {
                sbUrl.append(',');
            }
            sbUrl.append(addrs[i].toString());
        }
        if (!ConnectionPropertiesImpl.isEmpty(this.getSchema())) {
            sbUrl.append('/').append(this.getSchema());
        }
        return sbUrl.toString();
    }

    @Override
    public void setUrl(String url) throws SQLException {
        this.url = url;
        this.init(url, new Properties());
    }

    @Override
    public HostAndPortRange[] getAddresses() {
        return this.addrs;
    }

    @Override
    public void setAddresses(HostAndPortRange[] addrs) {
        this.addrs = addrs;
    }

    @Override
    public Integer getQueryTimeout() {
        return this.qryTimeout.value();
    }

    @Override
    public void setQueryTimeout(@Nullable Integer timeout) throws SQLException {
        this.qryTimeout.setValue(timeout);
    }

    @Override
    public Long getReconnectThrottlingPeriod() {
        return this.reconnectThrottlingPeriod.value();
    }

    @Override
    public void setReconnectThrottlingPeriod(Long period) throws SQLException {
        this.reconnectThrottlingPeriod.setValue(period);
    }

    @Override
    public Integer getReconnectThrottlingRetries() {
        return this.reconnectThrottlingRetries.value();
    }

    @Override
    public void setReconnectThrottlingRetries(Integer reconnectThrottlingRetries) throws SQLException {
        this.reconnectThrottlingRetries.setValue(reconnectThrottlingRetries);
    }

    @Override
    public int getConnectionTimeout() {
        return this.connTimeout.value();
    }

    @Override
    public void setConnectionTimeout(@Nullable Integer timeout) throws SQLException {
        this.connTimeout.setValue(timeout);
    }

    public void init(String url, Properties props) throws SQLException {
        assert (props != null);
        Properties props0 = (Properties)props.clone();
        if (!ConnectionPropertiesImpl.isEmpty(url)) {
            this.parseUrl(url, props0);
        }
        for (ConnectionProperty arr : this.propsArray) {
            arr.init(props0);
        }
    }

    private void parseUrl(String url, Properties props) throws SQLException {
        if (ConnectionPropertiesImpl.isEmpty(url)) {
            throw new SQLException("URL cannot be null or empty.");
        }
        if (!url.startsWith(URL_PREFIX)) {
            throw new SQLException("URL must start with \"jdbc:ignite:thin://\"");
        }
        String nakedUrl = url.substring(URL_PREFIX.length()).trim();
        this.parseUrl0(nakedUrl, props);
    }

    private void parseUrl0(String url, Properties props) throws SQLException {
        int semicolonPos = url.indexOf(";");
        int slashPos = url.indexOf("/");
        int queryPos = url.indexOf("?");
        boolean semicolonMode = semicolonPos == -1 && slashPos == -1 && queryPos == -1 ? true : (semicolonPos != -1 ? !(slashPos != -1 && semicolonPos >= slashPos || queryPos != -1 && semicolonPos >= queryPos) : false);
        if (semicolonMode) {
            this.parseUrlWithSemicolon(url, props);
        } else {
            this.parseUrlWithQuery(url, props);
        }
    }

    private void parseUrlWithSemicolon(String url, Properties props) throws SQLException {
        int pathPartEndPos = url.indexOf(59);
        if (pathPartEndPos == -1) {
            pathPartEndPos = url.length();
        }
        String pathPart = url.substring(0, pathPartEndPos);
        String paramPart = null;
        if (pathPartEndPos > 0 && pathPartEndPos < url.length()) {
            paramPart = url.substring(pathPartEndPos + 1);
        }
        this.parseEndpoints(pathPart);
        if (!ConnectionPropertiesImpl.isEmpty(paramPart)) {
            this.parseParameters(paramPart, props, ";");
        }
    }

    private void parseUrlWithQuery(String url, Properties props) throws SQLException {
        int pathPartEndPos = url.indexOf(63);
        if (pathPartEndPos == -1) {
            pathPartEndPos = url.length();
        }
        String pathPart = url.substring(0, pathPartEndPos);
        String paramPart = null;
        if (pathPartEndPos > 0 && pathPartEndPos < url.length()) {
            paramPart = url.substring(pathPartEndPos + 1);
        }
        String[] pathParts = pathPart.split("/");
        this.parseEndpoints(pathParts[0]);
        if (pathParts.length > 2) {
            throw new SQLException("Invalid URL format (only schema name is allowed in URL path parameter 'host:port[/schemaName]'): " + this.url, "08001");
        }
        this.setSchema(pathParts.length == 2 ? pathParts[1] : null);
        if (!ConnectionPropertiesImpl.isEmpty(paramPart)) {
            this.parseParameters(paramPart, props, "&");
        }
    }

    private void parseEndpoints(String endpointStr) throws SQLException {
        String[] endpoints = endpointStr.split(",");
        if (endpoints.length > 0) {
            this.addrs = new HostAndPortRange[endpoints.length];
        }
        for (int i = 0; i < endpoints.length; ++i) {
            try {
                this.addrs[i] = HostAndPortRange.parse(endpoints[i], 10800, 10800, "Invalid endpoint format (should be \"host[:portRangeFrom[..portRangeTo]]\")");
                continue;
            }
            catch (IgniteException e) {
                throw new SQLException(e.getMessage(), "08001", e);
            }
        }
        if (this.addrs == null || this.addrs.length == 0 || this.addrs[0].host() == null || this.addrs[0].host().isEmpty()) {
            throw new SQLException("Host name is empty", "08001");
        }
    }

    private void parseParameters(String paramStr, Properties props, String delimChar) throws SQLException {
        StringTokenizer st = new StringTokenizer(paramStr, delimChar);
        boolean insideBrace = false;
        String key = null;
        Object val = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!insideBrace) {
                int eqSymPos = token.indexOf(61);
                if (eqSymPos < 0) {
                    throw new SQLException("Invalid parameter format (should be \"key1=val1" + delimChar + "key2=val2" + delimChar + "...\"): " + token);
                }
                if (eqSymPos == token.length()) {
                    throw new SQLException("Invalid parameter format (key and value cannot be empty): " + token);
                }
                key = token.substring(0, eqSymPos);
                val = token.substring(eqSymPos + 1);
                if (((String)val).startsWith("{")) {
                    val = ((String)val).substring(1);
                    insideBrace = true;
                }
            } else {
                val = val + delimChar + token;
            }
            if (((String)val).endsWith("}")) {
                insideBrace = false;
                val = ((String)val).substring(0, ((String)val).length() - 1);
            }
            if (((String)val).contains("{") || ((String)val).contains("}")) {
                throw new SQLException("Braces cannot be escaped in the value. Please use the connection Properties for such values. [property=" + key + "]");
            }
            if (insideBrace) continue;
            if (key.isEmpty() || ((String)val).isEmpty()) {
                throw new SQLException("Invalid parameter format (key and value cannot be empty): " + token);
            }
            if (PROP_SCHEMA.equalsIgnoreCase(key)) {
                this.setSchema((String)val);
                continue;
            }
            props.setProperty(PROP_PREFIX + key, (String)val);
        }
    }

    public DriverPropertyInfo[] getDriverPropertyInfo() {
        DriverPropertyInfo[] infos = new DriverPropertyInfo[this.propsArray.length];
        for (int i = 0; i < this.propsArray.length; ++i) {
            infos[i] = this.propsArray[i].getDriverPropertyInfo();
        }
        return infos;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty() || str.isBlank();
    }

    private static class StringProperty
    extends ConnectionProperty {
        private static final long serialVersionUID = 0L;
        private String val;

        StringProperty(String name, String desc, String dfltVal, String[] choices, boolean required, PropertyValidator validator) {
            super(name, desc, dfltVal, choices, required, validator);
            this.val = dfltVal;
        }

        void setValue(String val) {
            this.val = val;
        }

        String value() {
            return this.val;
        }

        @Override
        void init(String str) throws SQLException {
            if (this.validator != null) {
                this.validator.validate(str);
            }
            this.val = str == null ? (String)this.dfltVal : str;
        }

        @Override
        String valueObject() {
            return this.val;
        }
    }

    private static class LongProperty
    extends NumberProperty {
        private static final long serialVersionUID = 0L;

        LongProperty(String name, String desc, Number dfltVal, boolean required, long min, long max) {
            super(name, desc, dfltVal, required, min, max);
        }

        @Override
        protected Number parse(String str) throws NumberFormatException {
            return Long.parseLong(str);
        }

        Long value() {
            return this.val != null ? Long.valueOf(this.val.longValue()) : null;
        }
    }

    private static class IntegerProperty
    extends NumberProperty {
        private static final long serialVersionUID = 0L;

        IntegerProperty(String name, String desc, Number dfltVal, boolean required, int min, int max) {
            super(name, desc, dfltVal, required, min, max);
        }

        @Override
        protected Number parse(String str) throws NumberFormatException {
            return Integer.parseInt(str);
        }

        Integer value() {
            return this.val != null ? Integer.valueOf(this.val.intValue()) : null;
        }
    }

    private static abstract class NumberProperty
    extends ConnectionProperty {
        private static final long serialVersionUID = 0L;
        protected Number val;
        private Number[] range;

        NumberProperty(String name, String desc, Number dfltVal, boolean required, Number min, Number max) {
            super(name, desc, dfltVal, null, required);
            this.val = dfltVal;
            this.range = new Number[]{min, max};
        }

        @Override
        void init(String str) throws SQLException {
            if (str == null) {
                this.val = this.dfltVal != null ? (Number)((Number)this.dfltVal) : (Number)null;
            } else {
                try {
                    this.setValue(this.parse(str));
                }
                catch (NumberFormatException e) {
                    throw new SQLException("Failed to parse int property [name=" + this.name + ", value=" + str + "]", "08001");
                }
            }
        }

        protected abstract Number parse(String var1) throws NumberFormatException;

        @Override
        String valueObject() {
            return this.val != null ? String.valueOf(this.val) : null;
        }

        void setValue(Number val) throws SQLException {
            if (this.range != null) {
                if (val.doubleValue() < this.range[0].doubleValue()) {
                    throw new SQLException("Property cannot be lower than " + this.range[0].toString() + " [name=" + this.name + ", value=" + val.toString() + "]", "08001");
                }
                if (val.doubleValue() > this.range[1].doubleValue()) {
                    throw new SQLException("Property cannot be upper than " + this.range[1].toString() + " [name=" + this.name + ", value=" + val.toString() + "]", "08001");
                }
            }
            this.val = val;
        }
    }

    private static abstract class ConnectionProperty
    implements Serializable {
        private static final long serialVersionUID = 0L;
        protected String name;
        protected String desc;
        protected Object dfltVal;
        protected String[] choices;
        protected boolean required;
        protected PropertyValidator validator;

        ConnectionProperty(String name, String desc, Object dfltVal, String[] choices, boolean required) {
            this.name = name;
            this.desc = desc;
            this.dfltVal = dfltVal;
            this.choices = choices;
            this.required = required;
        }

        ConnectionProperty(String name, String desc, Object dfltVal, String[] choices, boolean required, PropertyValidator validator) {
            this.name = name;
            this.desc = desc;
            this.dfltVal = dfltVal;
            this.choices = choices;
            this.required = required;
            this.validator = validator;
        }

        Object getDfltVal() {
            return this.dfltVal;
        }

        String getName() {
            return this.name;
        }

        String[] choices() {
            return this.choices;
        }

        void init(Properties props) throws SQLException {
            String strVal = props.getProperty(ConnectionPropertiesImpl.PROP_PREFIX + this.name);
            if (this.required && strVal == null) {
                throw new SQLException("Property '" + this.name + "' is required but not defined", "08001");
            }
            if (this.validator != null) {
                this.validator.validate(strVal);
            }
            this.checkChoices(strVal);
            props.remove(this.name);
            this.init(strVal);
        }

        abstract void init(String var1) throws SQLException;

        protected void checkChoices(String strVal) throws SQLException {
            if (strVal == null) {
                return;
            }
            if (this.choices != null) {
                for (String ch : this.choices) {
                    if (!ch.equalsIgnoreCase(strVal)) continue;
                    return;
                }
                throw new SQLException("Invalid property value. [name=" + this.name + ", val=" + strVal + ", choices=" + Arrays.toString(this.choices) + "]", "08001");
            }
        }

        abstract String valueObject();

        DriverPropertyInfo getDriverPropertyInfo() {
            DriverPropertyInfo dpi = new DriverPropertyInfo(ConnectionPropertiesImpl.PROP_PREFIX + this.name, this.valueObject());
            dpi.choices = this.choices();
            dpi.required = this.required;
            dpi.description = this.desc;
            return dpi;
        }
    }

    private static interface PropertyValidator
    extends Serializable {
        public void validate(String var1) throws SQLException;
    }
}

