/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

public enum CatalogColumnCollation {
    ASC_NULLS_FIRST(true, true),
    ASC_NULLS_LAST(true, false),
    DESC_NULLS_FIRST(false, true),
    DESC_NULLS_LAST(false, false);

    private static final int ASC_FLAG_BITMASK = 1;
    private static final int NULLS_FIRST_FLAG_BITMASK = 2;
    private final boolean asc;
    private final boolean nullsFirst;

    private CatalogColumnCollation(boolean asc, boolean nullsFirst) {
        this.asc = asc;
        this.nullsFirst = nullsFirst;
    }

    public static CatalogColumnCollation get(boolean asc, boolean nullsFirst) {
        if (asc && nullsFirst) {
            return ASC_NULLS_FIRST;
        }
        if (asc) {
            return ASC_NULLS_LAST;
        }
        if (nullsFirst) {
            return DESC_NULLS_FIRST;
        }
        return DESC_NULLS_LAST;
    }

    public boolean asc() {
        return this.asc;
    }

    public boolean nullsFirst() {
        return this.nullsFirst;
    }

    static byte pack(CatalogColumnCollation collation) {
        return (byte)((collation.asc() ? 1 : 0) | (collation.nullsFirst() ? 2 : 0));
    }

    static CatalogColumnCollation unpack(byte collationBits) {
        boolean asc = (collationBits & 1) == 1;
        boolean nullsFirst = (collationBits & 2) == 2;
        return CatalogColumnCollation.get(asc, nullsFirst);
    }
}

