/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.handlers;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.TxRecoveryEngine;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.TxRecoveryMessage;
import org.apache.ignite.internal.tx.storage.state.TxStatePartitionStorage;

public class TxRecoveryMessageHandler {
    private static final IgniteLogger LOG = Loggers.forClass(TxRecoveryMessageHandler.class);
    private final TxStatePartitionStorage txStatePartitionStorage;
    private final ReplicationGroupId replicationGroupId;
    private final TxRecoveryEngine txRecoveryEngine;

    public TxRecoveryMessageHandler(TxStatePartitionStorage txStatePartitionStorage, ReplicationGroupId replicationGroupId, TxRecoveryEngine txRecoveryEngine) {
        this.txStatePartitionStorage = txStatePartitionStorage;
        this.replicationGroupId = replicationGroupId;
        this.txRecoveryEngine = txRecoveryEngine;
    }

    public CompletableFuture<Void> handle(TxRecoveryMessage request, UUID senderId) {
        UUID txId = request.txId();
        TxMeta txMeta = this.txStatePartitionStorage.get(txId);
        if (txMeta != null && TxState.isFinalState((TxState)txMeta.txState())) {
            return this.txRecoveryEngine.runCleanupOnNode(this.replicationGroupId, txId, senderId);
        }
        LOG.info("Orphan transaction has to be aborted [tx={}, meta={}].", new Object[]{txId, txMeta});
        return this.txRecoveryEngine.triggerTxRecovery(txId, senderId);
    }
}

