/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.storage;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorageListener;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.apache.ignite.internal.configuration.util.ConfigurationSerializationUtil;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.EntryEvent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StringUtils;

public class DistributedConfigurationStorage
implements ConfigurationStorage {
    private static final IgniteLogger LOG = Loggers.forClass(DistributedConfigurationStorage.class);
    private static final String DISTRIBUTED_PREFIX = "dst-cfg.";
    private static final ByteArray MASTER_KEY = new ByteArray("dst-cfg.$master$key");
    private static final ByteArray DST_KEYS_START_RANGE = new ByteArray("dst-cfg.");
    private final MetaStorageManager metaStorageMgr;
    private volatile ConfigurationStorageListener lsnr;
    private volatile long changeId;
    private final ExecutorService threadPool;
    private final InFlightFutures futureTracker = new InFlightFutures();

    public DistributedConfigurationStorage(String nodeName, MetaStorageManager metaStorageMgr) {
        this.metaStorageMgr = metaStorageMgr;
        this.threadPool = Executors.newFixedThreadPool(4, (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"dst-cfg", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
    }

    public void close() {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.futureTracker.cancelInFlightFutures();
    }

    public CompletableFuture<Map<String, ? extends Serializable>> readAllLatest(String prefix) {
        ByteArray prefixBytes = new ByteArray(DISTRIBUTED_PREFIX + prefix);
        final CompletableFuture resultFuture = new CompletableFuture();
        this.metaStorageMgr.prefix(prefixBytes).subscribe(new Flow.Subscriber<Entry>(){
            private final Map<String, Serializable> data = new HashMap<String, Serializable>();

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(Entry item) {
                byte[] key = item.key();
                if (Arrays.equals(key, MASTER_KEY.bytes())) {
                    return;
                }
                byte[] value = item.value();
                assert (!item.tombstone());
                assert (value != null);
                String dataKey = new String(key, StandardCharsets.UTF_8).substring(DistributedConfigurationStorage.DISTRIBUTED_PREFIX.length());
                this.data.put(dataKey, ConfigurationSerializationUtil.fromBytes((byte[])value));
            }

            @Override
            public void onError(Throwable throwable) {
                resultFuture.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
                resultFuture.complete(this.data);
            }
        });
        return this.registerFuture(resultFuture);
    }

    public CompletableFuture<Serializable> readLatest(String key) {
        return ((CompletableFuture)this.metaStorageMgr.get(new ByteArray(DISTRIBUTED_PREFIX + key)).thenApply(entry -> {
            byte[] value = entry.value();
            return value == null ? null : ConfigurationSerializationUtil.fromBytes((byte[])value);
        })).exceptionally(e -> {
            throw new StorageException("Exception while reading data from Meta Storage", e);
        });
    }

    public CompletableFuture<Data> readDataOnRecovery() throws StorageException {
        CompletionStage future = this.metaStorageMgr.recoveryFinishedFuture().thenApplyAsync(revisions -> this.readDataOnRecovery0(revisions.revision()), (Executor)this.threadPool);
        return this.registerFuture((CompletableFuture)future);
    }

    private Data readDataOnRecovery0(long metaStorageRevision) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        long cfgRevision = 0L;
        byte[] masterKey = MASTER_KEY.bytes();
        boolean sawMasterKey = false;
        try (Cursor cursor = this.metaStorageMgr.prefixLocally(DST_KEYS_START_RANGE, metaStorageRevision);){
            for (Entry entry : cursor) {
                if (entry.tombstone()) continue;
                byte[] key = entry.key();
                byte[] value = entry.value();
                assert (value != null);
                if (!sawMasterKey && Arrays.equals(masterKey, key)) {
                    sawMasterKey = true;
                    cfgRevision = entry.revision();
                    continue;
                }
                String dataKey = StringUtils.toStringWithoutPrefix((byte[])key, (int)DST_KEYS_START_RANGE.length());
                data.put(dataKey, ConfigurationSerializationUtil.fromBytes((byte[])value));
            }
        }
        catch (Exception e) {
            throw new StorageException("Exception reading data on recovery", (Throwable)e);
        }
        assert (data.isEmpty() || cfgRevision > 0L);
        this.changeId = cfgRevision;
        return new Data(data, cfgRevision);
    }

    public CompletableFuture<Boolean> write(Map<String, ? extends Serializable> newValues, long curChangeId) {
        assert (curChangeId <= this.changeId);
        assert (this.lsnr != null) : "Configuration listener must be initialized before write.";
        if (curChangeId < this.changeId) {
            return CompletableFutures.falseCompletedFuture();
        }
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Map.Entry<String, ? extends Serializable> entry : newValues.entrySet()) {
            ByteArray key = new ByteArray(DISTRIBUTED_PREFIX + entry.getKey());
            if (entry.getValue() != null) {
                operations.add(Operations.put((ByteArray)key, (byte[])ConfigurationSerializationUtil.toBytes((Object)entry.getValue())));
                continue;
            }
            operations.add(Operations.remove((ByteArray)key));
        }
        operations.add(Operations.put((ByteArray)MASTER_KEY, (byte[])ByteUtils.longToBytes((long)curChangeId)));
        SimpleCondition condition = curChangeId == 0L ? Conditions.notExists((ByteArray)MASTER_KEY) : Conditions.revision((ByteArray)MASTER_KEY).eq(curChangeId);
        return this.metaStorageMgr.invoke((Condition)condition, operations, List.of(Operations.noop()));
    }

    public void registerConfigurationListener(ConfigurationStorageListener lsnr) {
        assert (this.lsnr == null);
        this.lsnr = lsnr;
        this.metaStorageMgr.registerPrefixWatch(DST_KEYS_START_RANGE, events -> {
            HashMap data = IgniteUtils.newHashMap((int)(events.entryEvents().size() - 1));
            Entry masterKeyEntry = null;
            for (EntryEvent event : events.entryEvents()) {
                Entry e = event.newEntry();
                if (Arrays.equals(e.key(), MASTER_KEY.bytes())) {
                    masterKeyEntry = e;
                    continue;
                }
                String key = new String(e.key(), StandardCharsets.UTF_8).substring(DISTRIBUTED_PREFIX.length());
                Serializable value = e.value() == null ? null : ConfigurationSerializationUtil.fromBytes((byte[])e.value());
                data.put(key, value);
            }
            assert (masterKeyEntry != null);
            long newChangeId = masterKeyEntry.revision();
            assert (newChangeId > this.changeId);
            this.changeId = newChangeId;
            return lsnr.onEntriesChanged(new Data((Map)data, newChangeId));
        });
    }

    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    public CompletableFuture<Long> lastRevision() {
        return this.metaStorageMgr.get(MASTER_KEY).thenApply(Entry::revision);
    }

    public CompletableFuture<Long> localRevision() {
        return this.metaStorageMgr.recoveryFinishedFuture().thenApply(revisions -> this.metaStorageMgr.getLocally(MASTER_KEY, revisions.revision()).revision());
    }

    private <T> CompletableFuture<T> registerFuture(CompletableFuture<T> future) {
        this.futureTracker.registerFuture(future);
        return future;
    }
}

