/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.recovery.cluster;

import java.util.List;
import org.apache.ignite3.internal.cli.commands.recovery.cluster.reset.ResetClusterMixin;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.jetbrains.annotations.Nullable;

public class ResetClusterCallInput
implements CallInput {
    private final String clusterUrl;
    @Nullable
    private final List<String> cmgNodeNames;
    @Nullable
    private final Integer metastorageReplicationFactor;

    public String clusterUrl() {
        return this.clusterUrl;
    }

    @Nullable
    public List<String> cmgNodeNames() {
        return this.cmgNodeNames;
    }

    @Nullable
    public Integer metastorageReplicationFactor() {
        return this.metastorageReplicationFactor;
    }

    private ResetClusterCallInput(String clusterUrl, @Nullable List<String> cmgNodeNames, @Nullable Integer metastorageReplicationFactor) {
        this.clusterUrl = clusterUrl;
        this.cmgNodeNames = cmgNodeNames == null ? null : List.copyOf(cmgNodeNames);
        this.metastorageReplicationFactor = metastorageReplicationFactor;
    }

    public static ResetClusterCallInput of(ResetClusterMixin statesArgs, String clusterUrl) {
        return ResetClusterCallInput.builder().cmgNodeNames(statesArgs.cmgNodeNames()).metastorageReplicationFactor(statesArgs.metastorageReplicationFactor()).clusterUrl(clusterUrl).build();
    }

    private static ResetClusterCallInputBuilder builder() {
        return new ResetClusterCallInputBuilder();
    }

    private static class ResetClusterCallInputBuilder {
        private String clusterUrl;
        @Nullable
        private List<String> cmgNodeNames;
        @Nullable
        private Integer metastorageReplicationFactor;

        private ResetClusterCallInputBuilder() {
        }

        ResetClusterCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        ResetClusterCallInputBuilder cmgNodeNames(@Nullable List<String> cmgNodeNames) {
            this.cmgNodeNames = cmgNodeNames;
            return this;
        }

        ResetClusterCallInputBuilder metastorageReplicationFactor(@Nullable Integer metastorageReplicationFactor) {
            this.metastorageReplicationFactor = metastorageReplicationFactor;
            return this;
        }

        ResetClusterCallInput build() {
            return new ResetClusterCallInput(this.clusterUrl, this.cmgNodeNames, this.metastorageReplicationFactor);
        }
    }
}

