/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.eventlog.api;

import java.util.Arrays;
import org.apache.ignite3.internal.eventlog.api.Event;
import org.apache.ignite3.internal.eventlog.event.EventBuilder;
import org.apache.ignite3.internal.eventlog.event.EventTypeRegistry;
import org.apache.ignite3.internal.eventlog.event.EventUser;

public enum IgniteEventType {
    USER_AUTHENTICATION_SUCCESS,
    USER_AUTHENTICATION_FAILURE,
    CLIENT_CONNECTION_ESTABLISHED,
    CLIENT_CONNECTION_CLOSED,
    COMPUTE_JOB_QUEUED,
    COMPUTE_JOB_EXECUTING,
    COMPUTE_JOB_FAILED,
    COMPUTE_JOB_COMPLETED,
    COMPUTE_JOB_CANCELING,
    COMPUTE_JOB_CANCELED,
    COMPUTE_TASK_QUEUED,
    COMPUTE_TASK_EXECUTING,
    COMPUTE_TASK_FAILED,
    COMPUTE_TASK_COMPLETED,
    COMPUTE_TASK_CANCELED,
    QUERY_STARTED,
    QUERY_FINISHED;


    public static void initialize() {
    }

    public Event create(EventUser user) {
        return this.builder().user(user).timestamp(System.currentTimeMillis()).build();
    }

    public EventBuilder builder() {
        return Event.builder().type(this.name());
    }

    static {
        Arrays.stream(IgniteEventType.values()).forEach(type -> EventTypeRegistry.register(type.name()));
    }
}

