/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDataRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.internal.util.typedef.F;

public abstract class ClientCacheKeyRequest
extends ClientCacheDataRequest
implements ClientTxAwareRequest {
    private final Object key;

    ClientCacheKeyRequest(BinaryRawReaderEx reader) {
        super(reader);
        this.key = reader.readObjectDetached();
    }

    @Override
    public final ClientResponse process(ClientConnectionContext ctx) {
        this.updateMetrics(ctx);
        return this.process0(ctx);
    }

    @Override
    public final IgniteInternalFuture<ClientResponse> processAsync(ClientConnectionContext ctx) {
        this.updateMetrics(ctx);
        return this.processAsync0(ctx);
    }

    @Override
    public boolean isAsync(ClientConnectionContext ctx) {
        return this.cacheDescriptor(ctx).cacheConfiguration().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL;
    }

    private void updateMetrics(ClientConnectionContext ctx) {
        DynamicCacheDescriptor desc;
        CacheConfiguration cfg;
        if (!this.isTransactional() && (cfg = (desc = this.cacheDescriptor(ctx)).cacheConfiguration()).getCacheMode() == CacheMode.PARTITIONED && cfg.isStatisticsEnabled()) {
            String cacheName = desc.cacheName();
            try {
                GridKernalContext kctx = ctx.kernalContext();
                if (F.first(kctx.affinity().mapKeyToPrimaryAndBackups(cacheName, this.key, null)).isLocal()) {
                    kctx.clientListener().metrics().onAffinityKeyHit();
                } else {
                    kctx.clientListener().metrics().onAffinityKeyMiss();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract ClientResponse process0(ClientConnectionContext var1);

    protected IgniteInternalFuture<ClientResponse> processAsync0(ClientConnectionContext ctx) {
        throw new IllegalStateException("Async operation is not implemented for request " + this.getClass().getName());
    }

    public Object key() {
        return this.key;
    }
}

