package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Variable Matrix Width data structure
 **/
@ApiModel(description = "Variable Matrix Width data structure")
@JsonTypeName("variableMatrixWidth")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class VariableMatrixWidth   {
  private @Valid BigDecimal coalesce;
  private @Valid BigDecimal minTileRow;
  private @Valid BigDecimal maxTileRow;

  /**
   * Number of tiles in width that coalesce in a single tile for these rows
   * minimum: 2
   **/
  public VariableMatrixWidth coalesce(BigDecimal coalesce) {
    this.coalesce = coalesce;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Number of tiles in width that coalesce in a single tile for these rows")
  @JsonProperty("coalesce")
  @NotNull
 @DecimalMin("2")  public BigDecimal getCoalesce() {
    return coalesce;
  }

  @JsonProperty("coalesce")
  public void setCoalesce(BigDecimal coalesce) {
    this.coalesce = coalesce;
  }

  /**
   * First tile row where the coalescence factor applies for this tilematrix
   * minimum: 0
   **/
  public VariableMatrixWidth minTileRow(BigDecimal minTileRow) {
    this.minTileRow = minTileRow;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "First tile row where the coalescence factor applies for this tilematrix")
  @JsonProperty("minTileRow")
  @NotNull
 @DecimalMin("0")  public BigDecimal getMinTileRow() {
    return minTileRow;
  }

  @JsonProperty("minTileRow")
  public void setMinTileRow(BigDecimal minTileRow) {
    this.minTileRow = minTileRow;
  }

  /**
   * Last tile row where the coalescence factor applies for this tilematrix
   * minimum: 0
   **/
  public VariableMatrixWidth maxTileRow(BigDecimal maxTileRow) {
    this.maxTileRow = maxTileRow;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Last tile row where the coalescence factor applies for this tilematrix")
  @JsonProperty("maxTileRow")
  @NotNull
 @DecimalMin("0")  public BigDecimal getMaxTileRow() {
    return maxTileRow;
  }

  @JsonProperty("maxTileRow")
  public void setMaxTileRow(BigDecimal maxTileRow) {
    this.maxTileRow = maxTileRow;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VariableMatrixWidth variableMatrixWidth = (VariableMatrixWidth) o;
    return Objects.equals(this.coalesce, variableMatrixWidth.coalesce) &&
        Objects.equals(this.minTileRow, variableMatrixWidth.minTileRow) &&
        Objects.equals(this.maxTileRow, variableMatrixWidth.maxTileRow);
  }

  @Override
  public int hashCode() {
    return Objects.hash(coalesce, minTileRow, maxTileRow);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VariableMatrixWidth {\n");
    
    sb.append("    coalesce: ").append(toIndentedString(coalesce)).append("\n");
    sb.append("    minTileRow: ").append(toIndentedString(minTileRow)).append("\n");
    sb.append("    maxTileRow: ").append(toIndentedString(maxTileRow)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

