/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.async;

import java.io.IOException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.cluster.client.BaseFactory;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.IClientManager;
import org.apache.iotdb.cluster.client.async.AsyncBaseFactory;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.TSDataService;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.async.TAsyncMethodCall;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataClient
extends TSDataService.AsyncClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncDataClient.class);
    private Node node;
    private ClientCategory category;
    private IClientManager clientManager;

    public AsyncDataClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, TNonblockingTransport transport) {
        super(protocolFactory, clientManager, transport);
    }

    public AsyncDataClient(TProtocolFactory protocolFactory, TAsyncClientManager tClientManager, Node node, ClientCategory category) throws IOException {
        super(protocolFactory, tClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)node.getInternalIp(), (int)ClientUtils.getPort(node, category), (int)ClusterConstant.getConnectionTimeoutInMS()));
        this.node = node;
        this.category = category;
    }

    public AsyncDataClient(TProtocolFactory protocolFactory, TAsyncClientManager tClientManager, Node node, ClientCategory category, IClientManager manager) throws IOException {
        this(protocolFactory, tClientManager, node, category);
        this.clientManager = manager;
    }

    public void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public boolean isValid() {
        return this.___transport != null;
    }

    private void returnSelf() {
        if (this.clientManager != null) {
            this.clientManager.returnAsyncClient((RaftService.AsyncClient)this, this.node, this.category);
        }
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public String toString() {
        return "Async" + this.category.getName() + "{node=" + this.node + ",port=" + ClientUtils.getPort(this.node, this.category) + '}';
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    TAsyncMethodCall<Object> getCurrMethod() {
        return this.___currentMethod;
    }

    public static class SingleManagerFactory
    extends BaseFactory<Node, AsyncDataClient> {
        public SingleManagerFactory(TProtocolFactory protocolFactory) {
            super(protocolFactory, ClientCategory.DATA);
            this.managers = new TAsyncClientManager[1];
            try {
                this.managers[0] = new TAsyncClientManager();
            }
            catch (IOException e) {
                logger.error("Cannot create data heartbeat client manager for factory", (Throwable)e);
            }
        }

        public SingleManagerFactory(TProtocolFactory protocolFactory, IClientManager clientManager) {
            this(protocolFactory);
            this.clientPoolManager = clientManager;
        }

        @Override
        public void activateObject(Node node, PooledObject<AsyncDataClient> pooledObject) {
        }

        public void destroyObject(Node node, PooledObject<AsyncDataClient> pooledObject) {
            ((AsyncDataClient)((Object)pooledObject.getObject())).close();
        }

        public PooledObject<AsyncDataClient> makeObject(Node node) throws Exception {
            return new DefaultPooledObject((Object)new AsyncDataClient(this.protocolFactory, this.managers[0], node, ClientCategory.DATA, this.clientPoolManager));
        }

        @Override
        public void passivateObject(Node node, PooledObject<AsyncDataClient> pooledObject) {
        }

        public boolean validateObject(Node node, PooledObject<AsyncDataClient> pooledObject) {
            return pooledObject.getObject() != null && ((AsyncDataClient)((Object)pooledObject.getObject())).isValid();
        }
    }

    public static class AsyncDataClientFactory
    extends AsyncBaseFactory<Node, AsyncDataClient> {
        public AsyncDataClientFactory(TProtocolFactory protocolFactory, ClientCategory category) {
            super(protocolFactory, category);
        }

        public AsyncDataClientFactory(TProtocolFactory protocolFactory, ClientCategory category, IClientManager clientManager) {
            super(protocolFactory, category, clientManager);
        }

        public void destroyObject(Node node, PooledObject<AsyncDataClient> pooledObject) {
            ((AsyncDataClient)((Object)pooledObject.getObject())).close();
        }

        public PooledObject<AsyncDataClient> makeObject(Node node) throws Exception {
            TAsyncClientManager manager = this.managers[this.clientCnt.incrementAndGet() % this.managers.length];
            manager = manager == null ? new TAsyncClientManager() : manager;
            return new DefaultPooledObject((Object)new AsyncDataClient(this.protocolFactory, manager, node, this.category, this.clientPoolManager));
        }

        public boolean validateObject(Node node, PooledObject<AsyncDataClient> pooledObject) {
            return pooledObject.getObject() != null && ((AsyncDataClient)((Object)pooledObject.getObject())).isValid();
        }
    }
}

