/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.Quota;

class LimitedQuota
implements Quota {
    private final int receiveMaximum;
    private int receivedQuota;

    public LimitedQuota(int receiveMaximum) {
        this.receiveMaximum = receiveMaximum;
        this.receivedQuota = receiveMaximum;
    }

    @Override
    public boolean hasLimit() {
        return this.receiveMaximum != 66560;
    }

    @Override
    public void consumeSlot() {
        assert (this.receivedQuota > 0);
        --this.receivedQuota;
    }

    @Override
    public void releaseSlot() {
        ++this.receivedQuota;
        assert (this.receivedQuota <= this.receiveMaximum);
    }

    @Override
    public boolean hasFreeSlots() {
        return this.receivedQuota != 0;
    }

    @Override
    public int getMaximum() {
        return this.receiveMaximum;
    }

    @Override
    public int availableSlots() {
        return this.receivedQuota;
    }

    public String toString() {
        return "limited quota to " + this.receivedQuota + " max slots: " + this.receiveMaximum;
    }
}

