/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.common.TimeseriesContext;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractRegionScanDataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.RegionScanForActiveTimeSeriesUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class ActiveTimeSeriesRegionScanOperator
extends AbstractRegionScanDataSourceOperator {
    private final Map<IDeviceID, Map<String, TimeseriesContext>> timeSeriesToSchemasInfo;
    private static final Binary VIEW_TYPE = new Binary("BASE".getBytes());
    private final Binary dataBaseName;
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ActiveTimeSeriesRegionScanOperator.class) + RamUsageEstimator.shallowSizeOfInstance(Map.class) + RamUsageEstimator.shallowSizeOfInstance(Binary.class);

    public ActiveTimeSeriesRegionScanOperator(OperatorContext operatorContext, PlanNodeId sourceId, Map<IDeviceID, Map<String, TimeseriesContext>> timeSeriesToSchemasInfo, Filter timeFilter, Map<IDeviceID, Long> ttlCache, boolean isOutputCount) {
        this.outputCount = isOutputCount;
        this.operatorContext = operatorContext;
        this.sourceId = sourceId;
        this.timeSeriesToSchemasInfo = timeSeriesToSchemasInfo;
        this.regionScanUtil = new RegionScanForActiveTimeSeriesUtil(timeFilter, ttlCache);
        this.dataBaseName = new Binary(operatorContext.getDriverContext().getFragmentInstanceContext().getDataRegion().getDatabaseName().getBytes(TSFileConfig.STRING_CHARSET));
    }

    @Override
    protected boolean getNextTsFileHandle() throws IOException {
        return ((RegionScanForActiveTimeSeriesUtil)this.regionScanUtil).nextTsFileHandle(this.timeSeriesToSchemasInfo);
    }

    @Override
    protected boolean isAllDataChecked() {
        return this.timeSeriesToSchemasInfo.isEmpty();
    }

    private void checkAndAppend(String info, ColumnBuilder columnBuilders) {
        if (info == null) {
            columnBuilders.appendNull();
        } else {
            columnBuilders.writeBinary(new Binary(info.getBytes(TSFileConfig.STRING_CHARSET)));
        }
    }

    @Override
    protected void updateActiveData() {
        TimeColumnBuilder timeColumnBuilder = this.resultTsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = this.resultTsBlockBuilder.getValueColumnBuilders();
        Map<IDeviceID, List<String>> activeTimeSeries = ((RegionScanForActiveTimeSeriesUtil)this.regionScanUtil).getActiveTimeSeries();
        if (this.outputCount) {
            for (Map.Entry<IDeviceID, List<String>> entry : activeTimeSeries.entrySet()) {
                List<String> timeSeriesList = entry.getValue();
                this.count += (long)timeSeriesList.size();
                this.removeTimeseriesListFromDevice(entry.getKey(), timeSeriesList);
            }
            return;
        }
        for (Map.Entry<IDeviceID, List<String>> entry : activeTimeSeries.entrySet()) {
            IDeviceID deviceID = entry.getKey();
            String deviceStr = ((PlainDeviceID)deviceID).toStringID();
            List<String> timeSeriesList = entry.getValue();
            Map<String, TimeseriesContext> timeSeriesInfo = this.timeSeriesToSchemasInfo.get(deviceID);
            for (String timeSeries : timeSeriesList) {
                TimeseriesContext schemaInfo = timeSeriesInfo.get(timeSeries);
                timeColumnBuilder.writeLong(-1L);
                columnBuilders[0].writeBinary(new Binary(this.contactDeviceAndMeasurement(deviceStr, timeSeries)));
                this.checkAndAppend(schemaInfo.getAlias(), columnBuilders[1]);
                columnBuilders[2].writeBinary(this.dataBaseName);
                this.checkAndAppend(schemaInfo.getDataType(), columnBuilders[3]);
                this.checkAndAppend(schemaInfo.getEncoding(), columnBuilders[4]);
                this.checkAndAppend(schemaInfo.getCompression(), columnBuilders[5]);
                this.checkAndAppend(schemaInfo.getTags(), columnBuilders[6]);
                this.checkAndAppend(schemaInfo.getAttributes(), columnBuilders[7]);
                this.checkAndAppend(schemaInfo.getDeadband(), columnBuilders[8]);
                this.checkAndAppend(schemaInfo.getDeadbandParameters(), columnBuilders[9]);
                columnBuilders[10].writeBinary(VIEW_TYPE);
                this.resultTsBlockBuilder.declarePosition();
            }
            this.removeTimeseriesListFromDevice(deviceID, timeSeriesList);
        }
    }

    private void removeTimeseriesListFromDevice(IDeviceID deviceID, List<String> timeSeriesList) {
        Map<String, TimeseriesContext> timeSeriesInfo = this.timeSeriesToSchemasInfo.get(deviceID);
        for (String timeSeries : timeSeriesList) {
            timeSeriesInfo.remove(timeSeries);
        }
        if (timeSeriesInfo.isEmpty()) {
            this.timeSeriesToSchemasInfo.remove(deviceID);
        }
    }

    private byte[] contactDeviceAndMeasurement(String deviceStr, String measurementId) {
        return (deviceStr + "." + measurementId).getBytes(TSFileConfig.STRING_CHARSET);
    }

    @Override
    protected List<TSDataType> getResultDataTypes() {
        if (this.outputCount) {
            return ColumnHeaderConstant.countTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        }
        return ColumnHeaderConstant.showTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + INSTANCE_SIZE;
    }
}

