/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.Cardinality;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.QueryCardinalityUtil;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class RemoveRedundantExists
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode().matching(node -> node.getSubqueryAssignments().values().stream().allMatch(ApplyNode.Exists.class::isInstance));

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode node, Captures captures, Rule.Context context) {
        BooleanLiteral result;
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(node.getInput().getOutputSymbols());
        Cardinality subqueryCardinality = QueryCardinalityUtil.extractCardinality(node.getSubquery(), context.getLookup());
        if (subqueryCardinality.isEmpty()) {
            result = BooleanLiteral.FALSE_LITERAL;
        } else if (subqueryCardinality.isAtLeastScalar()) {
            result = BooleanLiteral.TRUE_LITERAL;
        } else {
            return Rule.Result.empty();
        }
        for (Symbol output : node.getSubqueryAssignments().keySet()) {
            assignments.put(output, result);
        }
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().genPlanNodeId(), node.getInput(), assignments.build()));
    }
}

