/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.cq;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ActiveCQPlan
extends ConfigPhysicalPlan {
    private String cqId;
    private String md5;

    public ActiveCQPlan() {
        super(ConfigPhysicalPlanType.ACTIVE_CQ);
    }

    public ActiveCQPlan(String cqId, String md5) {
        super(ConfigPhysicalPlanType.ACTIVE_CQ);
        Validate.notNull((Object)cqId);
        Validate.notNull((Object)md5);
        this.cqId = cqId;
        this.md5 = md5;
    }

    public String getCqId() {
        return this.cqId;
    }

    public String getMd5() {
        return this.md5;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.cqId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.md5, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.cqId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.md5 = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActiveCQPlan that = (ActiveCQPlan)o;
        return this.cqId.equals(that.cqId) && this.md5.equals(that.md5);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cqId, this.md5);
    }
}

