/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value;

import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value.ValueWindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;

public class LastValueFunction
extends ValueWindowFunction {
    private final int channel;
    private final boolean ignoreNull;

    public LastValueFunction(int channel, boolean ignoreNull) {
        this.channel = channel;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, int frameStart, int frameEnd) {
        if (frameStart < 0) {
            builder.appendNull();
            return;
        }
        if (this.ignoreNull) {
            int pos;
            for (pos = frameEnd; pos >= frameStart && partition.isNull(this.channel, pos); --pos) {
            }
            if (pos < frameStart) {
                builder.appendNull();
            } else {
                partition.writeTo(builder, this.channel, pos);
            }
        } else if (partition.isNull(this.channel, frameEnd)) {
            builder.appendNull();
        } else {
            partition.writeTo(builder, this.channel, frameEnd);
        }
    }
}

