/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

@JsonPropertyOrder(value={"timestamps", "measurements_list", "data_types_list", "values_list", "is_aligned", "devices"})
public class InsertRecordsRequest {
    public static final String JSON_PROPERTY_TIMESTAMPS = "timestamps";
    @JsonProperty(value="timestamps")
    private List<Long> timestamps;
    public static final String JSON_PROPERTY_MEASUREMENTS_LIST = "measurements_list";
    @JsonProperty(value="measurements_list")
    private List<List<String>> measurementsList;
    public static final String JSON_PROPERTY_DATA_TYPES_LIST = "data_types_list";
    @JsonProperty(value="data_types_list")
    private List<List<String>> dataTypesList;
    public static final String JSON_PROPERTY_VALUES_LIST = "values_list";
    @JsonProperty(value="values_list")
    private List<List<Object>> valuesList;
    public static final String JSON_PROPERTY_IS_ALIGNED = "is_aligned";
    @JsonProperty(value="is_aligned")
    private Boolean isAligned;
    public static final String JSON_PROPERTY_DEVICES = "devices";
    @JsonProperty(value="devices")
    private List<String> devices;

    public InsertRecordsRequest timestamps(List<Long> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public InsertRecordsRequest addTimestampsItem(Long timestampsItem) {
        if (this.timestamps == null) {
            this.timestamps = new ArrayList<Long>();
        }
        this.timestamps.add(timestampsItem);
        return this;
    }

    @JsonProperty(value="timestamps")
    @ApiModelProperty(value="")
    public List<Long> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(List<Long> timestamps) {
        this.timestamps = timestamps;
    }

    public InsertRecordsRequest measurementsList(List<List<String>> measurementsList) {
        this.measurementsList = measurementsList;
        return this;
    }

    public InsertRecordsRequest addMeasurementsListItem(List<String> measurementsListItem) {
        if (this.measurementsList == null) {
            this.measurementsList = new ArrayList<List<String>>();
        }
        this.measurementsList.add(measurementsListItem);
        return this;
    }

    @JsonProperty(value="measurements_list")
    @ApiModelProperty(value="")
    @Valid
    public List<List<String>> getMeasurementsList() {
        return this.measurementsList;
    }

    public void setMeasurementsList(List<List<String>> measurementsList) {
        this.measurementsList = measurementsList;
    }

    public InsertRecordsRequest dataTypesList(List<List<String>> dataTypesList) {
        this.dataTypesList = dataTypesList;
        return this;
    }

    public InsertRecordsRequest addDataTypesListItem(List<String> dataTypesListItem) {
        if (this.dataTypesList == null) {
            this.dataTypesList = new ArrayList<List<String>>();
        }
        this.dataTypesList.add(dataTypesListItem);
        return this;
    }

    @JsonProperty(value="data_types_list")
    @ApiModelProperty(value="")
    @Valid
    public List<List<String>> getDataTypesList() {
        return this.dataTypesList;
    }

    public void setDataTypesList(List<List<String>> dataTypesList) {
        this.dataTypesList = dataTypesList;
    }

    public InsertRecordsRequest valuesList(List<List<Object>> valuesList) {
        this.valuesList = valuesList;
        return this;
    }

    public InsertRecordsRequest addValuesListItem(List<Object> valuesListItem) {
        if (this.valuesList == null) {
            this.valuesList = new ArrayList<List<Object>>();
        }
        this.valuesList.add(valuesListItem);
        return this;
    }

    @JsonProperty(value="values_list")
    @ApiModelProperty(value="")
    @Valid
    public List<List<Object>> getValuesList() {
        return this.valuesList;
    }

    public void setValuesList(List<List<Object>> valuesList) {
        this.valuesList = valuesList;
    }

    public InsertRecordsRequest isAligned(Boolean isAligned) {
        this.isAligned = isAligned;
        return this;
    }

    @JsonProperty(value="is_aligned")
    @ApiModelProperty(value="")
    public Boolean getIsAligned() {
        return this.isAligned;
    }

    public void setIsAligned(Boolean isAligned) {
        this.isAligned = isAligned;
    }

    public InsertRecordsRequest devices(List<String> devices) {
        this.devices = devices;
        return this;
    }

    public InsertRecordsRequest addDevicesItem(String devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<String>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @JsonProperty(value="devices")
    @ApiModelProperty(value="")
    public List<String> getDevices() {
        return this.devices;
    }

    public void setDevices(List<String> devices) {
        this.devices = devices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertRecordsRequest insertRecordsRequest = (InsertRecordsRequest)o;
        return Objects.equals(this.timestamps, insertRecordsRequest.timestamps) && Objects.equals(this.measurementsList, insertRecordsRequest.measurementsList) && Objects.equals(this.dataTypesList, insertRecordsRequest.dataTypesList) && Objects.equals(this.valuesList, insertRecordsRequest.valuesList) && Objects.equals(this.isAligned, insertRecordsRequest.isAligned) && Objects.equals(this.devices, insertRecordsRequest.devices);
    }

    public int hashCode() {
        return Objects.hash(this.timestamps, this.measurementsList, this.dataTypesList, this.valuesList, this.isAligned, this.devices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsertRecordsRequest {\n");
        sb.append("    timestamps: ").append(this.toIndentedString(this.timestamps)).append("\n");
        sb.append("    measurementsList: ").append(this.toIndentedString(this.measurementsList)).append("\n");
        sb.append("    dataTypesList: ").append(this.toIndentedString(this.dataTypesList)).append("\n");
        sb.append("    valuesList: ").append(this.toIndentedString(this.valuesList)).append("\n");
        sb.append("    isAligned: ").append(this.toIndentedString(this.isAligned)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

