/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.exception.metadata;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.rpc.TSStatusCode;

public class DatabaseConflictException
extends MetadataException {
    private final boolean isChild;
    private final String storageGroupPath;

    public DatabaseConflictException(String path, boolean isChild) {
        super(DatabaseConflictException.getMessage(path, isChild), TSStatusCode.DATABASE_CONFLICT.getStatusCode());
        this.isChild = isChild;
        this.storageGroupPath = path;
    }

    public boolean isChild() {
        return this.isChild;
    }

    public String getStorageGroupPath() {
        return this.storageGroupPath;
    }

    private static String getMessage(String path, boolean isChild) {
        if (isChild) {
            return String.format("some children of %s have already been created as database", path);
        }
        return String.format("%s has already been created as database", path);
    }
}

