/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.transaction.TransactionalMapper;
import reactor.core.publisher.Flux;

public abstract class AbstractMessageMapper
extends TransactionalMapper
implements MessageMapper {
    public static final int UNLIMITED = -1;
    protected final MailboxSession mailboxSession;
    private final UidProvider uidProvider;
    private final ModSeqProvider modSeqProvider;

    public AbstractMessageMapper(MailboxSession mailboxSession, UidProvider uidProvider, ModSeqProvider modSeqProvider) {
        this.mailboxSession = mailboxSession;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
    }

    @Override
    public ModSeq getHighestModSeq(Mailbox mailbox) throws MailboxException {
        return this.modSeqProvider.highestModSeq(mailbox);
    }

    @Override
    public Optional<MessageUid> getLastUid(Mailbox mailbox) throws MailboxException {
        return this.uidProvider.lastUid(mailbox);
    }

    @Override
    public MailboxCounters getMailboxCounters(Mailbox mailbox) throws MailboxException {
        return MailboxCounters.builder().mailboxId(mailbox.getMailboxId()).count(this.countMessagesInMailbox(mailbox)).unseen(this.countUnseenMessagesInMailbox(mailbox)).build();
    }

    @Override
    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange set) throws MailboxException {
        ArrayList<UpdatedFlags> updatedFlags = new ArrayList<UpdatedFlags>();
        Iterator<MailboxMessage> messages = this.findInMailbox(mailbox, set, MessageMapper.FetchType.METADATA, -1);
        if (!messages.hasNext()) {
            return ImmutableList.of().iterator();
        }
        ModSeq modSeq = this.modSeqProvider.nextModSeq(mailbox);
        while (messages.hasNext()) {
            MailboxMessage member = messages.next();
            Flags originalFlags = member.createFlags();
            member.setFlags(flagsUpdateCalculator.buildNewFlags(originalFlags));
            Flags newFlags = member.createFlags();
            if (UpdatedFlags.flagsChanged((Flags)originalFlags, (Flags)newFlags)) {
                member.setModSeq(modSeq);
                this.save(mailbox, member);
            }
            updatedFlags.add(UpdatedFlags.builder().uid(member.getUid()).messageId(member.getMessageId()).modSeq(member.getModSeq()).newFlags(newFlags).oldFlags(originalFlags).build());
        }
        return updatedFlags.iterator();
    }

    @Override
    public MessageMetaData add(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        message.setUid(this.uidProvider.nextUid(mailbox));
        if (this.modSeqProvider != null) {
            message.setModSeq(this.modSeqProvider.nextModSeq(mailbox));
        }
        MessageMetaData data = this.save(mailbox, message);
        return data;
    }

    @Override
    public MessageMetaData copy(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        MessageUid uid = this.uidProvider.nextUid(mailbox);
        ModSeq modSeq = this.modSeqProvider.nextModSeq(mailbox);
        MessageMetaData metaData = this.copy(mailbox, uid, modSeq, original);
        return metaData;
    }

    protected abstract MessageMetaData save(Mailbox var1, MailboxMessage var2) throws MailboxException;

    protected abstract long countUnseenMessagesInMailbox(Mailbox var1) throws MailboxException;

    protected abstract MessageMetaData copy(Mailbox var1, MessageUid var2, ModSeq var3, MailboxMessage var4) throws MailboxException;

    @Override
    public Flux<MessageUid> listAllMessageUids(Mailbox mailbox) {
        return this.findInMailboxReactive(mailbox, MessageRange.all(), MessageMapper.FetchType.METADATA, -1).map(MailboxMessage::getUid);
    }
}

