/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtils;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.james.mailbox.backup.zip.EntryTypeExtraField;
import org.apache.james.mailbox.backup.zip.StringExtraField;
import org.apache.james.mailbox.backup.zip.ZipEntryType;

public class ExtraFieldExtractor {
    public static Optional<String> getStringExtraField(ZipShort id, ZipEntry entry) throws ZipException {
        ZipExtraField[] extraFields = ExtraFieldUtils.parse((byte[])entry.getExtra());
        return Arrays.stream(extraFields).filter(field -> field.getHeaderId().equals((Object)id)).map(StringExtraField.class::cast).map(StringExtraField::getValue).findFirst().flatMap(Function.identity());
    }

    public static Optional<ZipEntryType> getEntryType(ZipEntry entry) {
        try {
            ZipExtraField[] extraFields = ExtraFieldUtils.parse((byte[])entry.getExtra());
            return Arrays.stream(extraFields).filter(field -> field.getHeaderId().equals((Object)EntryTypeExtraField.ID_AQ)).flatMap(extraField -> ((EntryTypeExtraField)extraField).getEnumValue().stream()).findFirst();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

