/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import com.google.common.base.CharMatcher;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.jmap.routes.DownloadRoutes$;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.compat.java8.FunctionConverters.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import shapeless._0;

@ScalaSignature(bytes="\u0006\u0005\t5u!B\u0012%\u0011\u0003yc!B\u0019%\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u0007\u0006\u0001\u000b\u0011B\u001f\t\u000f\u0011\u000b!\u0019!C\u0001\u000b\"1\u0011*\u0001Q\u0001\n\u00193A!\r\u0013\u0001\u0015\"Aqk\u0002BC\u0002\u0013\u0005\u0001\f\u0003\u0005`\u000f\t\u0005\t\u0015!\u0003Z\u0011!\u0001wA!b\u0001\n\u0003\t\u0007\u0002C3\b\u0005\u0003\u0005\u000b\u0011\u00022\t\u000be:A\u0011\u00014\t\u000fi<!\u0019!C\u0005w\"9\u0011qB\u0004!\u0002\u0013a\b\u0002CA\t\u000f\t\u0007I\u0011B>\t\u000f\u0005Mq\u0001)A\u0005y\"A\u0011QC\u0004C\u0002\u0013%1\u0010C\u0004\u0002\u0018\u001d\u0001\u000b\u0011\u0002?\t\u0011\u0005eqA1A\u0005\nmDq!a\u0007\bA\u0003%A\u0010C\u0005\u0002\u001e\u001d\u0011\r\u0011\"\u0003\u0002 !A\u0011QE\u0004!\u0002\u0013\t\t\u0003\u0003\u0004&\u000f\u0011\u0005\u0013q\u0005\u0005\b\u0003\u007f9A\u0011BA!\u0011\u001d\tyd\u0002C\u0005\u0003{Bq!!*\b\t\u0013\t9\u000bC\u0004\u00020\u001e!I!!-\t\u000f\u0005ew\u0001\"\u0003\u0002\\\"9\u0011Q]\u0004\u0005\n\u0005\u001d\bb\u0002B\u0012\u000f\u0011%!Q\u0005\u0005\b\u0005_9A\u0011\u0002B\u0019\u0011\u001d\u0011yc\u0002C\u0005\u0005wAqAa\u0011\b\t\u0013\u0011)\u0005C\u0005\u0003v\u001d\t\n\u0011\"\u0003\u0003x\u0005qAi\\<oY>\fGMU8vi\u0016\u001c(BA\u0013'\u0003\u0019\u0011x.\u001e;fg*\u0011q\u0005K\u0001\u0005U6\f\u0007O\u0003\u0002*U\u0005)!.Y7fg*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u0001\"\u0001M\u0001\u000e\u0003\u0011\u0012a\u0002R8x]2|\u0017\r\u001a*pkR,7o\u0005\u0002\u0002gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0018\u0002\r1{uiR#S+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!-\u0003\u0015\u0019HN\u001a\u001bk\u0013\t\u0011uH\u0001\u0004M_\u001e<WM]\u0001\b\u0019>;u)\u0012*!\u0003-\u0011UK\u0012$F%~\u001b\u0016JW#\u0016\u0003\u0019\u0003\"\u0001N$\n\u0005!+$aA%oi\u0006a!)\u0016$G\u000bJ{6+\u0013.FAM\u0019qaS*\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015\u0001\u00027b]\u001eT\u0011\u0001U\u0001\u0005U\u00064\u0018-\u0003\u0002S\u001b\n1qJ\u00196fGR\u0004\"\u0001V+\u000e\u0003\u0019J!A\u0016\u0014\u0003\u0015)k\u0015\t\u0015*pkR,7/A\u0007bkRDWM\u001c;jG\u0006$xN]\u000b\u00023B\u0011!,X\u0007\u00027*\u0011ALJ\u0001\u0005QR$\b/\u0003\u0002_7\ni\u0011)\u001e;iK:$\u0018nY1u_J\fa\"Y;uQ\u0016tG/[2bi>\u0014\b%A\u0007cY>\u0014'+Z:pYZ,'o]\u000b\u0002EB\u0011\u0001gY\u0005\u0003I\u0012\u0012QB\u00117pEJ+7o\u001c7wKJ\u001c\u0018A\u00042m_\n\u0014Vm]8mm\u0016\u00148\u000f\t\u000b\u0004O\",\bC\u0001\u0019\b\u0011\u00159F\u00021\u0001ZQ\u0011A'N]:\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017AB5oU\u0016\u001cGOC\u0001p\u0003\u0015Q\u0017M^1y\u0013\t\tHNA\u0003OC6,G-A\u0003wC2,X-I\u0001u\u0003!\u0011fiQ\u00179mI\n\u0004\"\u00021\r\u0001\u0004\u0011\u0007F\u0001\u0007x!\tY\u00070\u0003\u0002zY\n1\u0011J\u001c6fGR\fa\"Y2d_VtG/\u00133QCJ\fW.F\u0001}!\ri\u0018\u0011\u0002\b\u0004}\u0006\u0015\u0001CA@6\u001b\t\t\tAC\u0002\u0002\u00049\na\u0001\u0010:p_Rt\u0014bAA\u0004k\u00051\u0001K]3eK\u001aLA!a\u0003\u0002\u000e\t11\u000b\u001e:j]\u001eT1!a\u00026\u0003=\t7mY8v]RLE\rU1sC6\u0004\u0013a\u00032m_\nLE\rU1sC6\fAB\u00197pE&#\u0007+\u0019:b[\u0002\n\u0011B\\1nKB\u000b'/Y7\u0002\u00159\fW.\u001a)be\u0006l\u0007%\u0001\td_:$XM\u001c;UsB,\u0007+\u0019:b[\u0006\t2m\u001c8uK:$H+\u001f9f!\u0006\u0014\u0018-\u001c\u0011\u0002\u0017\u0011|wO\u001c7pC\u0012,&/[\u000b\u0003\u0003C\u00012\u0001TA\u0012\u0013\r\tY!T\u0001\rI><h\u000e\\8bIV\u0013\u0018\u000e\t\u000b\u0003\u0003S\u0001b!a\u000b\u00026\u0005eRBAA\u0017\u0015\u0011\ty#!\r\u0002\rM$(/Z1n\u0015\r\t\u0019dT\u0001\u0005kRLG.\u0003\u0003\u00028\u00055\"AB*ue\u0016\fW\u000eE\u0002U\u0003wI1!!\u0010'\u0005%QU*\u0011)S_V$X-A\u0002hKR$b!a\u0011\u0002^\u0005M\u0004CBA#\u0003'\n9&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003%\u0001XO\u00197jg\",'O\u0003\u0003\u0002N\u0005=\u0013\u0001B2pe\u0016T!!!\u0015\u0002\u000fI,\u0017m\u0019;pe&!\u0011QKA$\u0005\u0011iuN\\8\u0011\u00071\u000bI&C\u0002\u0002\\5\u0013AAV8jI\"9\u0011q\f\rA\u0002\u0005\u0005\u0014a\u0002:fcV,7\u000f\u001e\t\u0005\u0003G\ny'\u0004\u0002\u0002f)!\u0011qMA5\u0003\u0019\u0019XM\u001d<fe*\u0019A,a\u001b\u000b\t\u00055\u0014qJ\u0001\u0006]\u0016$H/_\u0005\u0005\u0003c\n)GA\tIiR\u00048+\u001a:wKJ\u0014V-];fgRDq!!\u001e\u0019\u0001\u0004\t9(\u0001\u0005sKN\u0004xN\\:f!\u0011\t\u0019'!\u001f\n\t\u0005m\u0014Q\r\u0002\u0013\u0011R$\boU3sm\u0016\u0014(+Z:q_:\u001cX\r\u0006\u0005\u0002\u0000\u0005E\u00151SAK!\u0019\t\t)a\"\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u0013\n)IC\u00027\u0003\u0017JA!!#\u0002\u0004\n)1+T8o_B\u0019A'!$\n\u0007\u0005=UG\u0001\u0003V]&$\bbBA03\u0001\u0007\u0011\u0011\r\u0005\b\u0003kJ\u0002\u0019AA<\u0011\u001d\t9*\u0007a\u0001\u00033\u000ba\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\ty\nK\u0001\b[\u0006LGNY8y\u0013\u0011\t\u0019+!(\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\u0006Qq-\u001a;JM>;h.\u001a:\u0015\u0011\u0005}\u0014\u0011VAV\u0003[Cq!a\u0018\u001b\u0001\u0004\t\t\u0007C\u0004\u0002vi\u0001\r!a\u001e\t\u000f\u0005]%\u00041\u0001\u0002\u001a\u0006aAm\\<oY>\fGM\u00117pERQ\u0011qPAZ\u0003{\u000by,a4\t\u000f\u0005U6\u00041\u0001\u00028\u0006aq\u000e\u001d;j_:\fGNT1nKB!A'!/}\u0013\r\tY,\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005U4\u00041\u0001\u0002x!9\u0011\u0011Y\u000eA\u0002\u0005\r\u0017a\u00042m_\n\u001cuN\u001c;f]R$\u0016\u0010]3\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002\u001e\u0006)Qn\u001c3fY&!\u0011QZAd\u0005-\u0019uN\u001c;f]R$\u0016\u0010]3\t\u000f\u0005E7\u00041\u0001\u0002T\u0006!!\r\\8c!\r\u0001\u0014Q[\u0005\u0004\u0003/$#\u0001\u0002\"m_\n\f1$\u00193e\u0007>tG/\u001a8u\t&\u001c\bo\\:ji&|g\u000eS3bI\u0016\u0014H\u0003BAo\u0003G\u0004r\u0001NAp\u0003o\n9(C\u0002\u0002bV\u0012\u0011BR;oGRLwN\\\u0019\t\u000f\u0005UF\u00041\u0001\u00028\u00061\u0012\r\u001a3D_:$XM\u001c;MK:<G\u000f\u001b%fC\u0012,'\u000f\u0006\u0003\u0002^\u0006%\bbBAv;\u0001\u0007\u0011Q^\u0001\bg&TX\r\u0016:z!\u0019\ty/a=\u0002x6\u0011\u0011\u0011\u001f\u0006\u0004\u0003g)\u0014\u0002BA{\u0003c\u00141\u0001\u0016:z!\u0011\tIP!\b\u000f\t\u0005m(q\u0003\b\u0005\u0003{\u0014\u0019B\u0004\u0003\u0002\u0000\n=a\u0002\u0002B\u0001\u0005\u001bqAAa\u0001\u0003\f9!!Q\u0001B\u0005\u001d\ry(qA\u0005\u0002[%\u00111\u0006L\u0005\u0003S)J!a\n\u0015\n\u0007\tEa%A\u0002ba&LA!!3\u0003\u0016)\u0019!\u0011\u0003\u0014\n\t\te!1D\u0001\u0005'&TXM\u0003\u0003\u0002J\nU\u0011\u0002\u0002B\u0010\u0005C\u0011AaU5{K*!!\u0011\u0004B\u000e\u00031\nG\rZ\"p]R,g\u000e\u001e#jgB|7/\u001b;j_:DU-\u00193feJ+w-\u0019:eS:<WI\\2pI&tw\r\u0006\u0004\u0002x\t\u001d\"1\u0006\u0005\u0007\u0005Sq\u0002\u0019\u0001?\u0002\t9\fW.\u001a\u0005\b\u0005[q\u0002\u0019AA<\u0003\u0011\u0011Xm\u001d9\u0002\u0015E,XM]=QCJ\fW\u000e\u0006\u0004\u00028\nM\"q\u0007\u0005\b\u0005ky\u0002\u0019AA1\u0003-AG\u000f\u001e9SKF,Xm\u001d;\t\r\ter\u00041\u0001}\u00035\u0001\u0018M]1nKR,'OT1nKR1\u0011q\u0017B\u001f\u0005\u007fAaA!\u000f!\u0001\u0004a\bB\u0002B!A\u0001\u0007A0A\u0002ve&\faB]3ta>tG\rR3uC&d7\u000f\u0006\u0005\u0002\u0000\t\u001d#1\nB-\u0011\u001d\u0011I%\ta\u0001\u0003o\n!\u0003\u001b;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\"9!QJ\u0011A\u0002\t=\u0013a\u00023fi\u0006LGn\u001d\t\u0005\u0005#\u0012)&\u0004\u0002\u0003T)\u0019\u0011Q\n\u0014\n\t\t]#1\u000b\u0002\u000f!J|'\r\\3n\t\u0016$\u0018-\u001b7t\u0011%\u0011Y&\tI\u0001\u0002\u0004\u0011i&\u0001\u0006ti\u0006$Xo]\"pI\u0016\u0004BAa\u0018\u0003r5\u0011!\u0011\r\u0006\u00049\n\r$\u0002\u0002B3\u0005O\nQaY8eK\u000eTAA!\u001b\u0003l\u00059\u0001.\u00198eY\u0016\u0014(\u0002BA7\u0005[R!Aa\u001c\u0002\u0005%|\u0017\u0002\u0002B:\u0005C\u0012!\u0003\u0013;uaJ+7\u000f]8og\u0016\u001cF/\u0019;vg\u0006A\"/Z:q_:$G)\u001a;bS2\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\te$\u0006\u0002B/\u0005wZ#A! \u0011\t\t}$\u0011R\u0007\u0003\u0005\u0003SAAa!\u0003\u0006\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000f+\u0014AC1o]>$\u0018\r^5p]&!!1\u0012BA\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DownloadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final BlobResolvers blobResolvers;
    private final String accountIdParam;
    private final String blobIdParam;
    private final String nameParam;
    private final String contentTypeParam;
    private final String downloadUri;

    public static int BUFFER_SIZE() {
        return DownloadRoutes$.MODULE$.BUFFER_SIZE();
    }

    public static Logger LOGGER() {
        return DownloadRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public BlobResolvers blobResolvers() {
        return this.blobResolvers;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String blobIdParam() {
        return this.blobIdParam;
    }

    private String nameParam() {
        return this.nameParam;
    }

    private String contentTypeParam() {
        return this.contentTypeParam;
    }

    private String downloadUri() {
        return this.downloadUri;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, this.downloadUri())).action((request, response) -> this.get(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.downloadUri())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private Mono<Void> get(HttpServerRequest request, HttpServerResponse response) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> this.getIfOwner(request, response, (MailboxSession)mailboxSession)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ForbiddenException) {
                HttpResponseStatus x$1 = HttpResponseStatus.FORBIDDEN;
                String x$2 = "You cannot download in others accounts";
                String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$3, x$1, x$4, "You cannot download in others accounts"), HttpResponseStatus.FORBIDDEN);
            }
            if (throwable instanceof UnauthorizedException) {
                UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                DownloadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                HttpResponseStatus x$5 = HttpResponseStatus.UNAUTHORIZED;
                String x$6 = unauthorizedException.getMessage();
                String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$7, x$5, x$8, x$6), HttpResponseStatus.UNAUTHORIZED);
            }
            if (throwable instanceof BlobNotFoundException) {
                HttpResponseStatus x$9 = HttpResponseStatus.NOT_FOUND;
                String x$10 = "The resource could not be found";
                String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "The resource could not be found"), HttpResponseStatus.NOT_FOUND);
            }
            DownloadRoutes$.MODULE$.LOGGER().error("Unexpected error upon downloads", throwable);
            HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String x$14 = throwable.getMessage();
            String x$15 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
            return this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }).subscribeOn(Schedulers.elastic()).asJava().then();
    }

    private SMono<BoxedUnit> get(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        return ((SMono)BlobId$.MODULE$.of(request.param((CharSequence)this.blobIdParam())).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)x$4 -> this.blobResolvers().resolve((BlobId)x$4, mailboxSession))).flatMap((Function1 & Serializable)blob -> this.downloadBlob(this.queryParam(request, this.nameParam()), response, (ContentType)this.queryParam(request, this.contentTypeParam()).map((Function1 & Serializable)x$1 -> ContentType.of((String)x$1)).getOrElse((Function0 & Serializable)() -> blob.contentType()), (Blob)blob).then());
    }

    private SMono<BoxedUnit> getIfOwner(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        Left left;
        IllegalArgumentException throwable;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, Id.IdConstraint>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            AccountId targetAccountId = new AccountId(string2);
            return (SMono)AccountId$.MODULE$.from(mailboxSession.getUser()).map((Function1 & Serializable)accountId -> BoxesRunTime.boxToBoolean((boolean)accountId.equals(targetAccountId))).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)value -> DownloadRoutes.$anonfun$getIfOwner$3(this, request, response, mailboxSession, BoxesRunTime.unboxToBoolean((Object)value)));
        }
        if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            return SMono$.MODULE$.error((Throwable)illegalArgumentException);
        }
        throw new MatchError(either);
    }

    private SMono<BoxedUnit> downloadBlob(Option<String> optionalName, HttpServerResponse response, ContentType blobContentType, Blob blob) {
        return SMono$.MODULE$.fromPublisher((Publisher)Mono.using(() -> blob.content(), stream -> ((HttpServerResponse)this.addContentDispositionHeader(optionalName).compose(this.addContentLengthHeader(blob.size())).apply((Object)response)).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)blobContentType.asString()).status(HttpResponseStatus.OK).send((Publisher)ReactorUtils.toChunks((InputStream)stream, (int)DownloadRoutes$.MODULE$.BUFFER_SIZE()).map(x$5 -> Unpooled.wrappedBuffer((ByteBuffer)x$5)).subscribeOn(Schedulers.elastic())).then(), (Consumer)package$.MODULE$.asJavaConsumer((Function1 & Serializable)stream -> {
            stream.close();
            return BoxedUnit.UNIT;
        }))).then();
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentDispositionHeader(Option<String> optionalName) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)optionalName.map((Function1 & Serializable)x$6 -> this.addContentDispositionHeaderRegardingEncoding((String)x$6, (HttpServerResponse)resp)).getOrElse((Function0 & Serializable)() -> resp);
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentLengthHeader(Try<Refined<Object, boolean.Not<numeric.Less<_0>>>> sizeTry) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)sizeTry.map((Function1 & Serializable)size -> resp.header((CharSequence)"Content-Length", (CharSequence)((Long)((Refined)size).value()).toString())).getOrElse((Function0 & Serializable)() -> resp);
    }

    private HttpServerResponse addContentDispositionHeaderRegardingEncoding(String name, HttpServerResponse resp) {
        if (CharMatcher.ascii().matchesAllOf((CharSequence)name)) {
            return resp.header((CharSequence)"Content-Disposition", (CharSequence)new StringBuilder(23).append("attachment; filename=\"").append(name).append("\"").toString());
        }
        return resp.header((CharSequence)"Content-Disposition", (CharSequence)new StringBuilder(24).append("attachment; filename*=\"").append(EncoderUtil.encodeEncodedWord((String)name, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN)).append("\"").toString());
    }

    private Option<String> queryParam(HttpServerRequest httpRequest, String parameterName) {
        return this.queryParam(parameterName, httpRequest.uri());
    }

    private Option<String> queryParam(String parameterName, String uri) {
        return Option$.MODULE$.apply(new QueryStringDecoder(uri).parameters().get(parameterName)).toList().flatMap((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7).asScala()).headOption();
    }

    private SMono<BoxedUnit> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json)).map((Function1 & Serializable)x$8 -> x$8.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(statusCode).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()).then());
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    public static final /* synthetic */ SMono $anonfun$getIfOwner$3(DownloadRoutes $this, HttpServerRequest request$3, HttpServerResponse response$3, MailboxSession mailboxSession$4, boolean value) {
        if (value) {
            return $this.get(request$3, response$3, mailboxSession$4);
        }
        return SMono$.MODULE$.error((Throwable)new ForbiddenException());
    }

    @Inject
    public DownloadRoutes(@Named(value="RFC-8621") Authenticator authenticator, BlobResolvers blobResolvers) {
        this.authenticator = authenticator;
        this.blobResolvers = blobResolvers;
        this.accountIdParam = "accountId";
        this.blobIdParam = "blobId";
        this.nameParam = "name";
        this.contentTypeParam = "type";
        this.downloadUri = new StringBuilder(15).append("/download/{").append(this.accountIdParam()).append("}/{").append(this.blobIdParam()).append("}").toString();
    }
}

