/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.MetricAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class BoxplotAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Double compression;
    public static final JsonpDeserializer<BoxplotAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoxplotAggregation::setupBoxplotAggregationDeserializer);

    private BoxplotAggregation(Builder builder) {
        super(builder);
        this.compression = builder.compression;
    }

    public static BoxplotAggregation of(Function<Builder, ObjectBuilder<BoxplotAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Boxplot;
    }

    @Nullable
    public final Double compression() {
        return this.compression;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.compression != null) {
            generator.writeKey("compression");
            generator.write(this.compression.doubleValue());
        }
    }

    protected static void setupBoxplotAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::compression, JsonpDeserializer.doubleDeserializer(), "compression");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BoxplotAggregation> {
        @Nullable
        private Double compression;

        public final Builder compression(@Nullable Double value) {
            this.compression = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoxplotAggregation build() {
            this._checkSingleUse();
            return new BoxplotAggregation(this);
        }
    }
}

