/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.MessageAttachmentRepresentation;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraMessageV3Table;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.HeaderAndBodyByteContent;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;

public class CassandraMessageDAOV3 {
    public static final long DEFAULT_LONG_VALUE = 0L;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final TypeCodec<Map<String, String>> MAP_OF_STRINGS_CODEC = CodecRegistry.DEFAULT.codecFor((DataType)DataTypes.frozenMapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT));
    private static final TypeCodec<List<String>> LIST_OF_STRINGS_CODEC = CodecRegistry.DEFAULT.codecFor((DataType)DataTypes.frozenListOf((DataType)DataTypes.TEXT));
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final BlobStore blobStore;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement insert;
    private final PreparedStatement delete;
    private final PreparedStatement select;
    private final PreparedStatement listBlobs;
    private final Cid.CidParser cidParser;
    private final UserDefinedType attachmentsType;
    private final TypeCodec<List<UdtValue>> attachmentCodec;

    @Inject
    public CassandraMessageDAOV3(CqlSession session, CassandraTypesProvider typesProvider, BlobStore blobStore, BlobId.Factory blobIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.blobStore = blobStore;
        this.blobIdFactory = blobIdFactory;
        this.insert = this.prepareInsert(session);
        this.delete = this.prepareDelete(session);
        this.select = this.prepareSelect(session);
        this.listBlobs = this.prepareSelectBlobs(session);
        this.cidParser = Cid.parser().relaxed();
        this.attachmentsType = typesProvider.getDefinedUserType(CassandraMessageV3Table.ATTACHMENTS.asCql(true));
        this.attachmentCodec = CodecRegistry.DEFAULT.codecFor((DataType)DataTypes.listOf((DataType)this.attachmentsType));
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageV3").all().where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)))).build());
    }

    private PreparedStatement prepareSelectBlobs(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"messageV3").columns(new CqlIdentifier[]{CassandraMessageV3Table.HEADER_CONTENT, CassandraMessageV3Table.BODY_CONTENT}).build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(((Update)QueryBuilder.update((String)"messageV3").set(new Assignment[]{Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.INTERNAL_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.INTERNAL_DATE)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.BODY_START_OCTET, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.BODY_START_OCTET)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.FULL_CONTENT_OCTETS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.FULL_CONTENT_OCTETS)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.BODY_OCTECTS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.BODY_OCTECTS)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.BODY_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.BODY_CONTENT)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.HEADER_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.HEADER_CONTENT)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_DESCRIPTION, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_DESCRIPTION)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_TYPE)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.MEDIA_TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.MEDIA_TYPE)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.SUB_TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.SUB_TYPE)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_ID)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_MD5, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_MD5)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_TRANSFER_ENCODING, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_TRANSFER_ENCODING)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_LOCATION, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_LOCATION)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_LANGUAGE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_LANGUAGE)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_PARAMETERS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_PARAMETERS)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_TYPE_PARAMETERS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.Properties.CONTENT_TYPE_PARAMETERS)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.TEXTUAL_LINE_COUNT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.TEXTUAL_LINE_COUNT)), Assignment.prepend((CqlIdentifier)CassandraMessageV3Table.ATTACHMENTS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.ATTACHMENTS))}).where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)))).build());
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"messageV3").where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)))).build());
    }

    public Mono<Tuple2<BlobId, BlobId>> save(MailboxMessage message) {
        return this.saveContent(message).flatMap(pair -> this.cassandraAsyncExecutor.executeVoid((Statement)this.boundWriteStatement(message, (Tuple2<BlobId, BlobId>)pair)).thenReturn(pair));
    }

    public Mono<Void> save(MessageRepresentation message) {
        CassandraMessageId messageId = (CassandraMessageId)message.getMessageId();
        BoundStatementBuilder boundStatement = (BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.insert.boundStatementBuilder(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get())).setInstant(CassandraMessageV3Table.INTERNAL_DATE, message.getInternalDate().toInstant())).setInt(CassandraMessageV3Table.BODY_START_OCTET, message.getBodyStartOctet().intValue())).setLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS, message.getSize().longValue())).setLong(CassandraMessageV3Table.BODY_OCTECTS, message.getSize() - (long)message.getBodyStartOctet().intValue())).setString(CassandraMessageV3Table.BODY_CONTENT, message.getBodyId().asString())).setString(CassandraMessageV3Table.HEADER_CONTENT, message.getHeaderId().asString())).setLong(CassandraMessageV3Table.TEXTUAL_LINE_COUNT, Optional.ofNullable(message.getProperties().getTextualLineCount()).orElse(0L).longValue())).setString(CassandraMessageV3Table.Properties.CONTENT_DESCRIPTION, message.getProperties().getContentDescription())).setString(CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_TYPE, message.getProperties().getContentDispositionType())).setString(CassandraMessageV3Table.Properties.MEDIA_TYPE, message.getProperties().getMediaType())).setString(CassandraMessageV3Table.Properties.SUB_TYPE, message.getProperties().getSubType())).setString(CassandraMessageV3Table.Properties.CONTENT_ID, message.getProperties().getContentID())).setString(CassandraMessageV3Table.Properties.CONTENT_MD5, message.getProperties().getContentMD5())).setString(CassandraMessageV3Table.Properties.CONTENT_TRANSFER_ENCODING, message.getProperties().getContentTransferEncoding())).setString(CassandraMessageV3Table.Properties.CONTENT_LOCATION, message.getProperties().getContentLocation())).set(CassandraMessageV3Table.Properties.CONTENT_LANGUAGE, (Object)message.getProperties().getContentLanguage(), LIST_OF_STRINGS_CODEC)).set(CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_PARAMETERS, (Object)message.getProperties().getContentDispositionParameters(), MAP_OF_STRINGS_CODEC)).set(CassandraMessageV3Table.Properties.CONTENT_TYPE_PARAMETERS, (Object)message.getProperties().getContentTypeParameters(), MAP_OF_STRINGS_CODEC);
        if (message.getAttachments().isEmpty()) {
            return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatementBuilder)boundStatement.unset(CassandraMessageV3Table.ATTACHMENTS)).build());
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatementBuilder)boundStatement.setList(CassandraMessageV3Table.ATTACHMENTS, this.buildAttachmentUdt(message.getAttachments()), UdtValue.class)).build());
    }

    private Mono<Tuple2<BlobId, BlobId>> saveContent(final MailboxMessage message) {
        return Mono.fromCallable(() -> IOUtils.toByteArray((InputStream)message.getHeaderContent(), (long)message.getHeaderOctets())).subscribeOn(Schedulers.boundedElastic()).flatMap(headerContent -> {
            ByteSource bodyByteSource = new ByteSource(){

                public InputStream openStream() {
                    try {
                        return message.getBodyContent();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public long size() {
                    return message.getBodyOctets();
                }
            };
            Mono headerFuture = Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), headerContent, BlobStore.StoragePolicy.SIZE_BASED));
            Mono bodyFuture = Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), bodyByteSource, BlobStore.StoragePolicy.LOW_COST));
            return headerFuture.zipWith(bodyFuture);
        });
    }

    private BoundStatement boundWriteStatement(MailboxMessage message, Tuple2<BlobId, BlobId> pair) {
        CassandraMessageId messageId = (CassandraMessageId)message.getMessageId();
        BoundStatement boundStatement = (BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get())).setInstant(CassandraMessageV3Table.INTERNAL_DATE, message.getInternalDate().toInstant())).setInt(CassandraMessageV3Table.BODY_START_OCTET, (int)message.getHeaderOctets())).setLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS, message.getFullContentOctets())).setLong(CassandraMessageV3Table.BODY_OCTECTS, message.getBodyOctets())).setString(CassandraMessageV3Table.BODY_CONTENT, ((BlobId)pair.getT2()).asString())).setString(CassandraMessageV3Table.HEADER_CONTENT, ((BlobId)pair.getT1()).asString())).setLong(CassandraMessageV3Table.TEXTUAL_LINE_COUNT, Optional.ofNullable(message.getTextualLineCount()).orElse(0L).longValue())).setString(CassandraMessageV3Table.Properties.CONTENT_DESCRIPTION, message.getProperties().getContentDescription())).setString(CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_TYPE, message.getProperties().getContentDispositionType())).setString(CassandraMessageV3Table.Properties.MEDIA_TYPE, message.getProperties().getMediaType())).setString(CassandraMessageV3Table.Properties.SUB_TYPE, message.getProperties().getSubType())).setString(CassandraMessageV3Table.Properties.CONTENT_ID, message.getProperties().getContentID())).setString(CassandraMessageV3Table.Properties.CONTENT_MD5, message.getProperties().getContentMD5())).setString(CassandraMessageV3Table.Properties.CONTENT_TRANSFER_ENCODING, message.getProperties().getContentTransferEncoding())).setString(CassandraMessageV3Table.Properties.CONTENT_LOCATION, message.getProperties().getContentLocation())).set(CassandraMessageV3Table.Properties.CONTENT_LANGUAGE, (Object)message.getProperties().getContentLanguage(), LIST_OF_STRINGS_CODEC)).set(CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_PARAMETERS, (Object)message.getProperties().getContentDispositionParameters(), MAP_OF_STRINGS_CODEC)).set(CassandraMessageV3Table.Properties.CONTENT_TYPE_PARAMETERS, (Object)message.getProperties().getContentTypeParameters(), MAP_OF_STRINGS_CODEC);
        if (message.getAttachments().isEmpty()) {
            return (BoundStatement)boundStatement.unset(CassandraMessageV3Table.ATTACHMENTS);
        }
        return (BoundStatement)boundStatement.setList(CassandraMessageV3Table.ATTACHMENTS, this.buildAttachmentUdt(message), UdtValue.class);
    }

    private ImmutableList<UdtValue> buildAttachmentUdt(MailboxMessage message) {
        return (ImmutableList)message.getAttachments().stream().map(this::toUDT).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<UdtValue> buildAttachmentUdt(List<MessageAttachmentRepresentation> attachments) {
        return (ImmutableList)attachments.stream().map(this::toUDT).collect(ImmutableList.toImmutableList());
    }

    private UdtValue toUDT(MessageAttachmentMetadata messageAttachment) {
        UdtValue result = (UdtValue)((UdtValue)this.attachmentsType.newValue().setString(CassandraMessageV3Table.Attachments.ID, messageAttachment.getAttachmentId().getId())).setBoolean(CassandraMessageV3Table.Attachments.IS_INLINE, messageAttachment.isInline());
        UdtValue setNameUdtValue = messageAttachment.getName().map(name -> (UdtValue)result.setString(CassandraMessageV3Table.Attachments.NAME, name)).orElse(result);
        return messageAttachment.getCid().map(cid -> (UdtValue)setNameUdtValue.setString(CassandraMessageV3Table.Attachments.CID, cid.getValue())).orElse(setNameUdtValue);
    }

    private UdtValue toUDT(MessageAttachmentRepresentation messageAttachment) {
        UdtValue result = (UdtValue)((UdtValue)this.attachmentsType.newValue().setString(CassandraMessageV3Table.Attachments.ID, messageAttachment.getAttachmentId().getId())).setBoolean(CassandraMessageV3Table.Attachments.IS_INLINE, messageAttachment.isInline());
        Optional<UdtValue> maybeSetNameUdtValue = messageAttachment.getName().map(name -> (UdtValue)result.setString(CassandraMessageV3Table.Attachments.NAME, name));
        Optional<UdtValue> maybeSetCidUdtValue = maybeSetNameUdtValue.map(setNameUdtValue -> messageAttachment.getCid().map(cid -> (UdtValue)setNameUdtValue.setString(CassandraMessageV3Table.Attachments.CID, cid.getValue())).orElse((UdtValue)setNameUdtValue));
        return maybeSetCidUdtValue.orElse(result);
    }

    public Mono<MessageRepresentation> retrieveMessage(ComposedMessageIdWithMetaData id, MessageMapper.FetchType fetchType) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)id.getComposedMessageId().getMessageId();
        return this.retrieveMessage(cassandraMessageId, fetchType);
    }

    public Mono<MessageRepresentation> retrieveMessage(CassandraMessageId cassandraMessageId, MessageMapper.FetchType fetchType) {
        return this.retrieveRow(cassandraMessageId).flatMap(row -> this.message((Row)row, cassandraMessageId, fetchType));
    }

    private Mono<Row> retrieveRow(CassandraMessageId messageId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind(new Object[0]).set(CassandraMessageIds.MESSAGE_ID, (Object)messageId.get(), TypeCodecs.TIMEUUID));
    }

    private Mono<MessageRepresentation> message(Row row, CassandraMessageId cassandraMessageId, MessageMapper.FetchType fetchType) {
        BlobId headerId = this.retrieveBlobId(CassandraMessageV3Table.HEADER_CONTENT, row);
        BlobId bodyId = this.retrieveBlobId(CassandraMessageV3Table.BODY_CONTENT, row);
        return this.buildContentRetriever(fetchType, headerId, bodyId).map(content -> new MessageRepresentation(cassandraMessageId, Optional.ofNullable((Instant)row.get(CassandraMessageV3Table.INTERNAL_DATE, TypeCodecs.TIMESTAMP)).map(Date::from).orElse(null), row.getLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS), row.getInt(CassandraMessageV3Table.BODY_START_OCTET), (Content)content, this.getProperties(row), this.getAttachments(row), headerId, bodyId));
    }

    private Properties getProperties(Row row) {
        PropertyBuilder property = new PropertyBuilder();
        property.setContentDescription((String)row.get(CassandraMessageV3Table.Properties.CONTENT_DESCRIPTION, TypeCodecs.TEXT));
        property.setContentDispositionType((String)row.get(CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_TYPE, TypeCodecs.TEXT));
        property.setMediaType((String)row.get(CassandraMessageV3Table.Properties.MEDIA_TYPE, TypeCodecs.TEXT));
        property.setSubType((String)row.get(CassandraMessageV3Table.Properties.SUB_TYPE, TypeCodecs.TEXT));
        property.setContentID((String)row.get(CassandraMessageV3Table.Properties.CONTENT_ID, TypeCodecs.TEXT));
        property.setContentMD5((String)row.get(CassandraMessageV3Table.Properties.CONTENT_MD5, TypeCodecs.TEXT));
        property.setContentTransferEncoding((String)row.get(CassandraMessageV3Table.Properties.CONTENT_TRANSFER_ENCODING, TypeCodecs.TEXT));
        property.setContentLocation((String)row.get(CassandraMessageV3Table.Properties.CONTENT_LOCATION, TypeCodecs.TEXT));
        property.setContentLanguage((List)row.get(CassandraMessageV3Table.Properties.CONTENT_LANGUAGE, LIST_OF_STRINGS_CODEC));
        property.setContentDispositionParameters((Map)row.get(CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_PARAMETERS, MAP_OF_STRINGS_CODEC));
        property.setContentTypeParameters((Map)row.get(CassandraMessageV3Table.Properties.CONTENT_TYPE_PARAMETERS, MAP_OF_STRINGS_CODEC));
        property.setTextualLineCount(Long.valueOf(row.getLong(CassandraMessageV3Table.TEXTUAL_LINE_COUNT)));
        return property.build();
    }

    private List<MessageAttachmentRepresentation> getAttachments(Row row) {
        return Optional.ofNullable((List)row.get(CassandraMessageV3Table.ATTACHMENTS, this.attachmentCodec)).map(this::attachmentByIds).orElseGet(ImmutableList::of);
    }

    private List<MessageAttachmentRepresentation> attachmentByIds(List<UdtValue> udtValues) {
        return (List)udtValues.stream().map(this::messageAttachmentByIdFrom).collect(ImmutableList.toImmutableList());
    }

    private MessageAttachmentRepresentation messageAttachmentByIdFrom(UdtValue udtValue) {
        return MessageAttachmentRepresentation.builder().attachmentId(AttachmentId.from((String)((String)udtValue.get(CassandraMessageV3Table.Attachments.ID, TypeCodecs.TEXT)))).name((String)udtValue.get(CassandraMessageV3Table.Attachments.NAME, TypeCodecs.TEXT)).cid(this.cidParser.parse((String)udtValue.get(CassandraMessageV3Table.Attachments.CID, TypeCodecs.TEXT))).isInline(udtValue.getBoolean(CassandraMessageV3Table.Attachments.IS_INLINE)).build();
    }

    public Mono<Void> delete(CassandraMessageId messageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get()));
    }

    private Mono<Content> buildContentRetriever(MessageMapper.FetchType fetchType, BlobId headerId, BlobId bodyId) {
        switch (fetchType) {
            case FULL: {
                return this.getFullContent(headerId, bodyId);
            }
            case ATTACHMENTS_METADATA: 
            case HEADERS: {
                return this.getContent(headerId, BlobStore.StoragePolicy.SIZE_BASED).map(ByteContent::new);
            }
            case METADATA: {
                return Mono.just((Object)new ByteContent(EMPTY_BYTE_ARRAY));
            }
        }
        throw new RuntimeException("Unknown FetchType " + fetchType);
    }

    private Mono<Content> getFullContent(BlobId headerId, BlobId bodyId) {
        return this.getContent(headerId, BlobStore.StoragePolicy.SIZE_BASED).zipWith(this.getContent(bodyId, BlobStore.StoragePolicy.LOW_COST), HeaderAndBodyByteContent::new);
    }

    private Mono<byte[]> getContent(BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return Mono.from((Publisher)this.blobStore.readBytes(this.blobStore.getDefaultBucketName(), blobId, storagePolicy));
    }

    private BlobId retrieveBlobId(CqlIdentifier field, Row row) {
        return this.blobIdFactory.from((String)row.get(field, TypeCodecs.TEXT));
    }

    Flux<BlobId> listBlobs() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listBlobs.bind(new Object[0])).flatMapIterable(row -> ImmutableList.of((Object)this.blobIdFactory.from((String)row.get(CassandraMessageV3Table.HEADER_CONTENT, TypeCodecs.TEXT)), (Object)this.blobIdFactory.from((String)row.get(CassandraMessageV3Table.BODY_CONTENT, TypeCodecs.TEXT))));
    }
}

