/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.ClassificationInferenceOptions;
import org.opensearch.client.opensearch._types.aggregations.RegressionInferenceOptions;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class InferenceConfig
implements JsonpSerializable {
    @Nullable
    private final RegressionInferenceOptions regression;
    @Nullable
    private final ClassificationInferenceOptions classification;
    public static final JsonpDeserializer<InferenceConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceConfig::setupInferenceConfigDeserializer);

    private InferenceConfig(Builder builder) {
        this.regression = builder.regression;
        this.classification = builder.classification;
    }

    public static InferenceConfig of(Function<Builder, ObjectBuilder<InferenceConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final RegressionInferenceOptions regression() {
        return this.regression;
    }

    @Nullable
    public final ClassificationInferenceOptions classification() {
        return this.classification;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.regression != null) {
            generator.writeKey("regression");
            this.regression.serialize(generator, mapper);
        }
        if (this.classification != null) {
            generator.writeKey("classification");
            this.classification.serialize(generator, mapper);
        }
    }

    protected static void setupInferenceConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::regression, RegressionInferenceOptions._DESERIALIZER, "regression");
        op.add(Builder::classification, ClassificationInferenceOptions._DESERIALIZER, "classification");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<InferenceConfig> {
        @Nullable
        private RegressionInferenceOptions regression;
        @Nullable
        private ClassificationInferenceOptions classification;

        public final Builder regression(@Nullable RegressionInferenceOptions value) {
            this.regression = value;
            return this;
        }

        public final Builder regression(Function<RegressionInferenceOptions.Builder, ObjectBuilder<RegressionInferenceOptions>> fn) {
            return this.regression(fn.apply(new RegressionInferenceOptions.Builder()).build());
        }

        public final Builder classification(@Nullable ClassificationInferenceOptions value) {
            this.classification = value;
            return this;
        }

        public final Builder classification(Function<ClassificationInferenceOptions.Builder, ObjectBuilder<ClassificationInferenceOptions>> fn) {
            return this.classification(fn.apply(new ClassificationInferenceOptions.Builder()).build());
        }

        @Override
        public InferenceConfig build() {
            this._checkSingleUse();
            return new InferenceConfig(this);
        }
    }
}

