/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.access;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.primitives.Ints;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.access.AccessToken;
import org.apache.james.jmap.cassandra.access.table.CassandraAccessTokenTable;
import reactor.core.publisher.Mono;

public class CassandraAccessTokenDAO {
    private static final String TTL = "ttl";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement removeStatement;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final int durationInSeconds;

    @Inject
    public CassandraAccessTokenDAO(CqlSession session, @Named(value="tokenExpirationInMs") long durationInMilliseconds) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.durationInSeconds = Ints.checkedCast((long)TimeUnit.MILLISECONDS.toSeconds(durationInMilliseconds));
        this.removeStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"access_token").whereColumn(CassandraAccessTokenTable.TOKEN).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAccessTokenTable.TOKEN))).build());
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"access_token").value(CassandraAccessTokenTable.TOKEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAccessTokenTable.TOKEN)).value(CassandraAccessTokenTable.USERNAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAccessTokenTable.USERNAME)).usingTtl(QueryBuilder.bindMarker((String)TTL)).build());
        this.selectStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"access_token").column(CassandraAccessTokenTable.USERNAME).whereColumn(CassandraAccessTokenTable.TOKEN).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAccessTokenTable.TOKEN))).build());
    }

    public Mono<Void> addToken(Username username, AccessToken accessToken) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setUuid(CassandraAccessTokenTable.TOKEN, accessToken.asUUID())).setString(CassandraAccessTokenTable.USERNAME, username.asString())).setInt(TTL, this.durationInSeconds));
    }

    public Mono<Void> removeToken(AccessToken accessToken) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.removeStatement.bind(new Object[0]).setUuid(CassandraAccessTokenTable.TOKEN, accessToken.asUUID()));
    }

    public Mono<Username> getUsernameFromToken(AccessToken accessToken) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectStatement.bind(new Object[0]).set(CassandraAccessTokenTable.TOKEN, (Object)accessToken.asUUID(), TypeCodecs.UUID)).map(row -> (String)row.get(0, TypeCodecs.TEXT)).map(Username::of);
    }
}

