/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class QuotaDTO {
    private final Optional<Long> count;
    private final Optional<Long> size;

    public static Builder builder() {
        return new Builder();
    }

    private QuotaDTO(Optional<Long> count, Optional<Long> size) {
        this.count = count;
        this.size = size;
    }

    public Optional<Long> getCount() {
        return this.count;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o instanceof QuotaDTO) {
            QuotaDTO that = (QuotaDTO)o;
            return Objects.equals(this.count, that.count) && Objects.equals(this.size, that.size);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("size", this.size).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Optional<Long> count = Optional.empty();
        private Optional<Long> size = Optional.empty();

        private Builder() {
        }

        public Builder count(Optional<Long> count) {
            this.count = count;
            return this;
        }

        public Builder size(Optional<Long> size) {
            this.size = size;
            return this;
        }

        public QuotaDTO build() {
            return new QuotaDTO(this.count, this.size);
        }
    }
}

