/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.query;

import org.apache.james.mailbox.model.SearchQuery;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.SortMode;
import org.opensearch.client.opensearch._types.SortOrder;

public class SortConverter {
    private static final String PATH_SEPARATOR = ".";

    public static FieldSort convertSort(SearchQuery.Sort sort) {
        return SortConverter.getSortClause(sort.getSortClause()).order(SortConverter.getOrder(sort)).mode(SortMode.Min).build();
    }

    private static FieldSort.Builder getSortClause(SearchQuery.Sort.SortClause clause) {
        switch (clause) {
            case Arrival: {
                return new FieldSort.Builder().field("date");
            }
            case MailboxCc: {
                return new FieldSort.Builder().field("cc.address.raw");
            }
            case MailboxFrom: {
                return new FieldSort.Builder().field("from.address.raw");
            }
            case MailboxTo: {
                return new FieldSort.Builder().field("to.address.raw");
            }
            case BaseSubject: {
                return new FieldSort.Builder().field("subject.raw");
            }
            case Size: {
                return new FieldSort.Builder().field("size");
            }
            case SentDate: {
                return new FieldSort.Builder().field("sentDate");
            }
            case Uid: {
                return new FieldSort.Builder().field("uid");
            }
            case Id: {
                return new FieldSort.Builder().field("messageId");
            }
        }
        throw new RuntimeException("Sort is not implemented");
    }

    private static SortOrder getOrder(SearchQuery.Sort sort) {
        if (sort.isReverse()) {
            return SortOrder.Desc;
        }
        return SortOrder.Asc;
    }
}

