/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.cassandra.quota.Limits;
import org.apache.james.mailbox.cassandra.quota.QuotaCodec;
import org.apache.james.mailbox.cassandra.table.CassandraDomainMaxQuota;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

public class CassandraPerDomainMaxQuotaDao {
    private final CassandraAsyncExecutor queryExecutor;
    private final PreparedStatement setMaxStorageStatement;
    private final PreparedStatement setMaxMessageStatement;
    private final PreparedStatement getMaxStatement;
    private final PreparedStatement removeMaxStorageStatement;
    private final PreparedStatement removeMaxMessageStatement;

    @Inject
    public CassandraPerDomainMaxQuotaDao(CqlSession session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
        this.setMaxStorageStatement = session.prepare(this.setMaxStorageStatement().build());
        this.setMaxMessageStatement = session.prepare(this.setMaxMessageStatement().build());
        this.getMaxStatement = session.prepare(this.getMaxStatement().build());
        this.removeMaxStorageStatement = session.prepare(this.removeMaxStorageStatement().build());
        this.removeMaxMessageStatement = session.prepare(this.removeMaxMessageStatement().build());
    }

    private Delete removeMaxMessageStatement() {
        return (Delete)QueryBuilder.deleteFrom((String)"domainMaxQuota").column(CassandraDomainMaxQuota.MESSAGE_COUNT).where((Relation)Relation.column((CqlIdentifier)CassandraDomainMaxQuota.DOMAIN).isEqualTo((Term)QueryBuilder.bindMarker()));
    }

    private Delete removeMaxStorageStatement() {
        return (Delete)QueryBuilder.deleteFrom((String)"domainMaxQuota").column(CassandraDomainMaxQuota.STORAGE).where((Relation)Relation.column((CqlIdentifier)CassandraDomainMaxQuota.DOMAIN).isEqualTo((Term)QueryBuilder.bindMarker()));
    }

    private Select getMaxStatement() {
        return (Select)QueryBuilder.selectFrom((String)"domainMaxQuota").all().where((Relation)Relation.column((CqlIdentifier)CassandraDomainMaxQuota.DOMAIN).isEqualTo((Term)QueryBuilder.bindMarker()));
    }

    private Insert setMaxMessageStatement() {
        return QueryBuilder.insertInto((String)"domainMaxQuota").value(CassandraDomainMaxQuota.DOMAIN, (Term)QueryBuilder.bindMarker()).value(CassandraDomainMaxQuota.MESSAGE_COUNT, (Term)QueryBuilder.bindMarker());
    }

    private Insert setMaxStorageStatement() {
        return QueryBuilder.insertInto((String)"domainMaxQuota").value(CassandraDomainMaxQuota.DOMAIN, (Term)QueryBuilder.bindMarker()).value(CassandraDomainMaxQuota.STORAGE, (Term)QueryBuilder.bindMarker());
    }

    Mono<Void> setMaxStorage(Domain domain, QuotaSizeLimit maxStorageQuota) {
        return this.queryExecutor.executeVoid((Statement)this.setMaxStorageStatement.bind(new Object[]{domain.asString(), QuotaCodec.quotaValueToLong(maxStorageQuota)}));
    }

    Mono<Void> setMaxMessage(Domain domain, QuotaCountLimit maxMessageCount) {
        return this.queryExecutor.executeVoid((Statement)this.setMaxMessageStatement.bind(new Object[]{domain.asString(), QuotaCodec.quotaValueToLong(maxMessageCount)}));
    }

    Mono<QuotaSizeLimit> getMaxStorage(Domain domain) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{domain.asString()})).map(row -> Optional.ofNullable((Long)row.get(CassandraDomainMaxQuota.STORAGE, Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaSize).handle(ReactorUtils.publishIfPresent());
    }

    Mono<QuotaCountLimit> getMaxMessage(Domain domain) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{domain.asString()})).map(row -> Optional.ofNullable((Long)row.get(CassandraDomainMaxQuota.MESSAGE_COUNT, Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaCount).handle(ReactorUtils.publishIfPresent());
    }

    Mono<Limits> getLimits(Domain domain) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{domain.asString()})).map(row -> {
            Optional<Long> sizeLimit = Optional.ofNullable((Long)row.get(CassandraDomainMaxQuota.STORAGE, Long.class));
            Optional<Long> countLimit = Optional.ofNullable((Long)row.get(CassandraDomainMaxQuota.MESSAGE_COUNT, Long.class));
            return new Limits(sizeLimit.flatMap(QuotaCodec::longToQuotaSize), countLimit.flatMap(QuotaCodec::longToQuotaCount));
        }).switchIfEmpty(Mono.just((Object)Limits.empty()));
    }

    Mono<Void> removeMaxMessage(Domain domain) {
        return this.queryExecutor.executeVoid((Statement)this.removeMaxMessageStatement.bind(new Object[]{domain.asString()}));
    }

    Mono<Void> removeMaxStorage(Domain domain) {
        return this.queryExecutor.executeVoid((Statement)this.removeMaxStorageStatement.bind(new Object[]{domain.asString()}));
    }
}

