/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.ClearMailQueueTask;

public class RepublishNotprocessedMailsTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"republish-not-processed-mails");
    private final MailQueueName name;
    private final ClearMailQueueTask.MailQueueFactory factory;
    private final Instant olderThan;
    private final AtomicInteger nbRequeuedMails;

    public RepublishNotprocessedMailsTask(MailQueueName name, ClearMailQueueTask.MailQueueFactory factory, Instant olderThan) {
        this.name = name;
        this.factory = factory;
        this.olderThan = olderThan;
        this.nbRequeuedMails = new AtomicInteger(0);
    }

    public Task.Result run() {
        try (RabbitMQMailQueue queue = (RabbitMQMailQueue)this.factory.create(this.name);){
            queue.republishNotProcessedMails(this.olderThan).doOnNext(mailName -> this.nbRequeuedMails.getAndIncrement()).then().block();
        }
        catch (MailQueue.MailQueueException e) {
            LOGGER.error("Error when republishing mails", (Throwable)e);
            return Task.Result.PARTIAL;
        }
        return Task.Result.COMPLETED;
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.name, this.olderThan, this.nbRequeuedMails.get(), Clock.systemUTC().instant()));
    }

    public Instant getOlderThan() {
        return this.olderThan;
    }

    public MailQueueName getMailQueue() {
        return this.name;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final long nbRequeuedMails;
        private final MailQueueName mailQueue;
        private final Instant olderThan;

        public AdditionalInformation(MailQueueName mailQueue, Instant olderThan, long nbRequeuedMails, Instant timestamp) {
            this.mailQueue = mailQueue;
            this.olderThan = olderThan;
            this.timestamp = timestamp;
            this.nbRequeuedMails = nbRequeuedMails;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public Instant getOlderThan() {
            return this.olderThan;
        }

        public MailQueueName getMailQueue() {
            return this.mailQueue;
        }

        public long getNbRequeuedMails() {
            return this.nbRequeuedMails;
        }
    }
}

