/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ValidationResult {
    public static final String UNDEFINED_PROPERTY = "__UNDEFINED__";
    private final String property;
    private final String errorMessage;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    ValidationResult(String property, String errorMessage) {
        this.property = property;
        this.errorMessage = errorMessage;
    }

    public String getProperty() {
        return this.property;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (o instanceof ValidationResult) {
            ValidationResult otherEMailer = (ValidationResult)o;
            return Objects.equals(this.property, otherEMailer.property) && Objects.equals(this.errorMessage, otherEMailer.errorMessage);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.property, this.errorMessage);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("property", (Object)this.property).add("errorMessage", (Object)this.errorMessage).toString();
    }

    public static class Builder {
        private String property;
        private String errorMessage;

        public Builder property(String property) {
            this.property = property;
            return this;
        }

        public Builder message(String message) {
            this.errorMessage = message;
            return this;
        }

        public ValidationResult build() {
            return new ValidationResult(this.property, this.errorMessage);
        }
    }
}

