/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.api.model.Preview;

public class PreviewDTO {
    private static final String NO_BODY_AS_STRING = "(Empty)";
    public static final PreviewDTO NO_BODY = PreviewDTO.of("(Empty)");
    private final String value;

    public static PreviewDTO from(Optional<Preview> preview) {
        return preview.map(Preview::getValue).map(PreviewDTO::of).orElse(NO_BODY);
    }

    @VisibleForTesting
    public static PreviewDTO of(String value) {
        return new PreviewDTO(value);
    }

    private PreviewDTO(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = Optional.of(value).filter(previewValue -> !previewValue.isEmpty()).orElse(NO_BODY_AS_STRING);
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof PreviewDTO) {
            PreviewDTO that = (PreviewDTO)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

