/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.core;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.ForbiddenDelegationException;
import org.apache.james.util.ReactorUtils;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m3Aa\u0002\u0005\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003F\u0001\u0011%a\tC\u0003M\u0001\u0011%Q\nC\u0003X\u0001\u0011%\u0001LA\tTKN\u001c\u0018n\u001c8Ue\u0006t7\u000f\\1u_JT!!\u0003\u0006\u0002\t\r|'/\u001a\u0006\u0003\u00171\tAA[7ba*\u0011QBD\u0001\u0006U\u0006lWm\u001d\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-A\btKN\u001c\u0018n\u001c8Qe>4\u0018\u000eZ3s!\tar$D\u0001\u001e\u0015\tqB\"A\u0004nC&d'm\u001c=\n\u0005\u0001j\"aD*fgNLwN\u001c)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t\u0001\u0002C\u0003\u001b\u0005\u0001\u00071\u0004\u000b\u0002\u0003OA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0007S:TWm\u0019;\u000b\u00031\nQA[1wCbL!AL\u0015\u0003\r%s'.Z2u\u0003A!W\r\\3hCR,\u0017J\u001a(fK\u0012,G\rF\u00022}\u0001\u00032AM\u001d<\u001b\u0005\u0019$B\u0001\u001b6\u0003%\u0001XO\u00197jg\",'O\u0003\u0002\u0018m)\u0011\u0011b\u000e\u0006\u0002q\u00059!/Z1di>\u0014\u0018B\u0001\u001e4\u0005\u0015\u0019Vj\u001c8p!\taB(\u0003\u0002>;\tqQ*Y5mE>D8+Z:tS>t\u0007\"B \u0004\u0001\u0004Y\u0014aB:fgNLwN\u001c\u0005\u0006\u0003\u000e\u0001\rAQ\u0001\u0010i\u0006\u0014x-\u001a;BG\u000e|WO\u001c;JIB\u0011AeQ\u0005\u0003\t\"\u0011\u0011\"Q2d_VtG/\u00133\u0002\u001d9,W\r\u001a#fY\u0016<\u0017\r^5p]R\u0019qIS&\u0011\u0005UA\u0015BA%\u0017\u0005\u001d\u0011un\u001c7fC:DQa\u0010\u0003A\u0002mBQ!\u0011\u0003A\u0002\t\u000bA\u0002[1t\u0003\u000e\u001cw.\u001e8u\u0013\u0012$\"A\u0014,\u0015\u0005\u001d{\u0005\"\u0002)\u0006\u0001\u0004\t\u0016\u0001C;tKJt\u0017-\\3\u0011\u0005I#V\"A*\u000b\u0005%a\u0011BA+T\u0005!)6/\u001a:oC6,\u0007\"B!\u0006\u0001\u0004\u0011\u0015\u0001\u00033fY\u0016<\u0017\r^3\u0015\u0007EJ&\fC\u0003@\r\u0001\u00071\bC\u0003B\r\u0001\u0007!\t")
public class SessionTranslator {
    private final SessionProvider sessionProvider;

    public SMono<MailboxSession> delegateIfNeeded(MailboxSession session, AccountId targetAccountId) {
        if (this.needDelegation(session, targetAccountId)) {
            return this.delegate(session, targetAccountId);
        }
        return SMono$.MODULE$.just((Object)session);
    }

    private boolean needDelegation(MailboxSession session, AccountId targetAccountId) {
        return !this.hasAccountId(targetAccountId, session.getUser());
    }

    private boolean hasAccountId(AccountId targetAccountId, Username username) {
        return AccountId$.MODULE$.from(username).toOption().contains((Object)targetAccountId);
    }

    private SMono<MailboxSession> delegate(MailboxSession session, AccountId targetAccountId) {
        return SMono$.MODULE$.fromCallable(() -> $this.sessionProvider.authenticate(session.getUser()).forMatchingUser(user -> this.hasAccountId(targetAccountId, (Username)user))).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ForbiddenDelegationException) {
                return SMono$.MODULE$.error((Throwable)new AccountNotFoundException());
            }
            return SMono$.MODULE$.error(throwable);
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    @Inject
    public SessionTranslator(SessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }
}

