/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.mailbox.opensearch.OpenSearchMailboxConfiguration;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceLoader;
import org.apache.james.utils.NamingScheme;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchMailboxConfigurationModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchMailboxConfigurationModule.class);
    public static final String OPENSEARCH_CONFIGURATION_NAME = "opensearch";

    @Provides
    Set<ListeningMessageSearchIndex.SearchOverride> provideSearchOverrides(GuiceLoader loader, OpenSearchConfiguration configuration) {
        return (Set)configuration.getSearchOverrides().stream().map(ClassName::new).map(Throwing.function(arg_0 -> ((GuiceLoader.InvocationPerformer)loader.withNamingSheme(NamingScheme.IDENTITY)).instantiate(arg_0))).peek(routes -> LOGGER.info("Loading Search override {}", (Object)routes.getClass().getCanonicalName())).collect(ImmutableSet.toImmutableSet());
    }

    @Provides
    @Singleton
    private OpenSearchConfiguration getOpenSearchConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(OPENSEARCH_CONFIGURATION_NAME);
            return OpenSearchConfiguration.fromProperties((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find opensearch configuration file. Using {}:{} as contact point", (Object)"127.0.0.1", (Object)9200);
            return OpenSearchConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @Provides
    @Singleton
    private OpenSearchMailboxConfiguration getOpenSearchMailboxConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(OPENSEARCH_CONFIGURATION_NAME);
            return OpenSearchMailboxConfiguration.fromProperties((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find opensearch configuration file. Providing a default OPENSearchMailboxConfiguration");
            return OpenSearchMailboxConfiguration.DEFAULT_CONFIGURATION;
        }
    }
}

