/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.client.RequestOptions;
import org.reactivestreams.Publisher;

public class StreamingRequest<T> {
    private final String method;
    private final String endpoint;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private RequestOptions options = RequestOptions.DEFAULT;
    private final Publisher<T> publisher;

    public StreamingRequest(String method, String endpoint, Publisher<T> publisher) {
        this.method = method;
        this.endpoint = endpoint;
        this.publisher = publisher;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getMethod() {
        return this.method;
    }

    public RequestOptions getOptions() {
        return this.options;
    }

    public Map<String, String> getParameters() {
        if (this.options.getParameters().isEmpty()) {
            return Collections.unmodifiableMap(this.parameters);
        }
        HashMap<String, String> combinedParameters = new HashMap<String, String>(this.parameters);
        combinedParameters.putAll(this.options.getParameters());
        return Collections.unmodifiableMap(combinedParameters);
    }

    public void addParameter(String name, String value) {
        Objects.requireNonNull(name, "url parameter name cannot be null");
        if (this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("url parameter [" + name + "] has already been set to [" + this.parameters.get(name) + "]");
        }
        this.parameters.put(name, value);
    }

    public void addParameters(Map<String, String> paramSource) {
        paramSource.forEach(this::addParameter);
    }

    public Publisher<T> getBody() {
        return this.publisher;
    }
}

