/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres.quota;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.james.backends.postgres.quota.PostgresQuotaDataDefinition;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaLimit;
import org.apache.james.core.quota.QuotaScope;
import org.apache.james.core.quota.QuotaType;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresQuotaLimitDAO {
    private static final Long EMPTY_QUOTA_LIMIT = null;
    private final PostgresExecutor postgresExecutor;

    @Inject
    public PostgresQuotaLimitDAO(@Named(value="default") PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<QuotaLimit> getQuotaLimit(QuotaLimit.QuotaLimitKey quotaKey) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.selectFrom(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.TABLE_NAME).where(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_COMPONENT.eq((Object)quotaKey.getQuotaComponent().getValue())).and(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_SCOPE.eq((Object)quotaKey.getQuotaScope().getValue())).and(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.IDENTIFIER.eq((Object)quotaKey.getIdentifier())).and(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_TYPE.eq((Object)quotaKey.getQuotaType().getValue())))).map(this::asQuotaLimit);
    }

    public Flux<QuotaLimit> getQuotaLimits(QuotaComponent quotaComponent, QuotaScope quotaScope, String identifier) {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.TABLE_NAME).where(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_COMPONENT.eq((Object)quotaComponent.getValue())).and(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_SCOPE.eq((Object)quotaScope.getValue())).and(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.IDENTIFIER.eq((Object)identifier)))).map(this::asQuotaLimit);
    }

    public Mono<Void> setQuotaLimit(QuotaLimit quotaLimit) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.TABLE_NAME, PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_SCOPE, PostgresQuotaDataDefinition.PostgresQuotaLimitTable.IDENTIFIER, PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_COMPONENT, PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_TYPE, PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_LIMIT).values((Object)quotaLimit.getQuotaScope().getValue(), (Object)quotaLimit.getIdentifier(), (Object)quotaLimit.getQuotaComponent().getValue(), (Object)quotaLimit.getQuotaType().getValue(), (Object)quotaLimit.getQuotaLimit().orElse(EMPTY_QUOTA_LIMIT)).onConflictOnConstraint(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.PK_CONSTRAINT_NAME).doUpdate().set(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_LIMIT, (Object)quotaLimit.getQuotaLimit().orElse(EMPTY_QUOTA_LIMIT))));
    }

    public Mono<Void> deleteQuotaLimit(QuotaLimit.QuotaLimitKey quotaKey) {
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.TABLE_NAME).where(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_COMPONENT.eq((Object)quotaKey.getQuotaComponent().getValue())).and(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_SCOPE.eq((Object)quotaKey.getQuotaScope().getValue())).and(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.IDENTIFIER.eq((Object)quotaKey.getIdentifier())).and(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_TYPE.eq((Object)quotaKey.getQuotaType().getValue()))));
    }

    private QuotaLimit asQuotaLimit(Record record) {
        return QuotaLimit.builder().quotaComponent(QuotaComponent.of((String)((String)record.get(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_COMPONENT)))).quotaScope(QuotaScope.of((String)((String)record.get(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_SCOPE)))).identifier((String)record.get(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.IDENTIFIER)).quotaType(QuotaType.of((String)((String)record.get(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_TYPE)))).quotaLimit((Long)record.get(PostgresQuotaDataDefinition.PostgresQuotaLimitTable.QUOTA_LIMIT)).build();
    }
}

