/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.MatchingEntryCountType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchingEntryCountResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String MATCHING_ENTRY_COUNT_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.37";
    private static final byte TYPE_DEBUG_INFO = -96;
    private static final byte TYPE_SEARCH_INDEXED = -127;
    private static final byte TYPE_SHORT_CIRCUITED = -126;
    private static final byte TYPE_FULLY_INDEXED = -125;
    private static final byte TYPE_CANDIDATES_ARE_IN_SCOPE = -124;
    private static final byte TYPE_REMAINING_FILTER = -91;
    @NotNull
    private static final String JSON_FIELD_CANDIDATES_ARE_IN_SCOPE = "candidates-are-in-scope";
    @NotNull
    private static final String JSON_FIELD_COUNT_TYPE = "count-type";
    @NotNull
    private static final String JSON_FIELD_COUNT_VALUE = "count-value";
    @NotNull
    private static final String JSON_FIELD_DEBUG_INFO = "debug-info";
    @NotNull
    private static final String JSON_FIELD_FULLY_INDEXED = "fully-indexed";
    @NotNull
    private static final String JSON_FIELD_REMAINING_FILTER = "remaining-filter";
    @NotNull
    private static final String JSON_FIELD_SEARCH_INDEXED = "search-indexed";
    @NotNull
    private static final String JSON_FIELD_SHORT_CIRCUITED = "short-circuited";
    @NotNull
    private static final String JSON_COUNT_TYPE_EXAMINED_COUNT = "examined-count";
    @NotNull
    private static final String JSON_COUNT_TYPE_UNEXAMINED_COUNT = "unexamined-count";
    @NotNull
    private static final String JSON_COUNT_TYPE_UNKNOWN = "unknown";
    @NotNull
    private static final String JSON_COUNT_TYPE_UPPER_BOUND = "upper-bound";
    private static final long serialVersionUID = -7808452580964236458L;
    private final boolean searchIndexed;
    @Nullable
    private final Boolean candidatesAreInScope;
    @Nullable
    private final Boolean fullyIndexed;
    @Nullable
    private final Boolean shortCircuited;
    @Nullable
    private final Filter remainingFilter;
    private final int countValue;
    @NotNull
    private final List<String> debugInfo;
    @NotNull
    private final MatchingEntryCountType countType;

    MatchingEntryCountResponseControl() {
        this.searchIndexed = false;
        this.candidatesAreInScope = null;
        this.fullyIndexed = null;
        this.shortCircuited = null;
        this.remainingFilter = null;
        this.countValue = -1;
        this.countType = null;
        this.debugInfo = null;
    }

    private MatchingEntryCountResponseControl(@NotNull MatchingEntryCountType countType, int countValue, boolean searchIndexed, @Nullable Boolean shortCircuited, @Nullable Boolean fullyIndexed, @Nullable Boolean candidatesAreInScope, @Nullable Filter remainingFilter, @Nullable Collection<String> debugInfo) {
        super(MATCHING_ENTRY_COUNT_RESPONSE_OID, false, MatchingEntryCountResponseControl.encodeValue(countType, countValue, searchIndexed, shortCircuited, fullyIndexed, candidatesAreInScope, remainingFilter, debugInfo));
        this.countType = countType;
        this.countValue = countValue;
        this.searchIndexed = searchIndexed;
        this.shortCircuited = shortCircuited;
        this.fullyIndexed = fullyIndexed;
        this.candidatesAreInScope = candidatesAreInScope;
        this.remainingFilter = remainingFilter;
        this.debugInfo = debugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(debugInfo));
    }

    public MatchingEntryCountResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_MISSING_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.countType = MatchingEntryCountType.valueOf(elements[0].getType());
            if (this.countType == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_INVALID_COUNT_TYPE.get(StaticUtils.toHex(elements[0].getType())));
            }
            switch (this.countType) {
                case EXAMINED_COUNT: 
                case UNEXAMINED_COUNT: {
                    this.countValue = ASN1Integer.decodeAsInteger(elements[0]).intValue();
                    if (this.countValue >= 0) break;
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_NEGATIVE_EXACT_COUNT.get());
                }
                case UPPER_BOUND: {
                    this.countValue = ASN1Integer.decodeAsInteger(elements[0]).intValue();
                    if (this.countValue > 0) break;
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_NON_POSITIVE_UPPER_BOUND.get());
                }
                default: {
                    this.countValue = -1;
                }
            }
            boolean decodedSearchIndexed = this.countType != MatchingEntryCountType.UNKNOWN;
            Boolean decodedFullyIndexed = null;
            Boolean decodedCandidatesAreInScope = null;
            Boolean decodedShortCircuited = null;
            Filter decodedRemainingFilter = null;
            List debugMessages = Collections.emptyList();
            block15: for (int i = 1; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -96: {
                        ASN1Element[] debugElements = ASN1Sequence.decodeAsSequence(elements[i]).elements();
                        debugMessages = new ArrayList(debugElements.length);
                        for (ASN1Element e : debugElements) {
                            debugMessages.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        continue block15;
                    }
                    case -127: {
                        decodedSearchIndexed = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block15;
                    }
                    case -126: {
                        decodedShortCircuited = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block15;
                    }
                    case -125: {
                        decodedFullyIndexed = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block15;
                    }
                    case -124: {
                        decodedCandidatesAreInScope = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block15;
                    }
                    case -91: {
                        ASN1Element filterElement = ASN1Element.decode(elements[i].getValue());
                        decodedRemainingFilter = Filter.decode(filterElement);
                    }
                }
            }
            this.searchIndexed = decodedSearchIndexed;
            this.shortCircuited = decodedShortCircuited;
            this.fullyIndexed = decodedFullyIndexed;
            this.candidatesAreInScope = decodedCandidatesAreInScope;
            this.remainingFilter = decodedRemainingFilter;
            this.debugInfo = Collections.unmodifiableList(debugMessages);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static MatchingEntryCountResponseControl createExactCountResponse(int count, boolean examined, @Nullable Collection<String> debugInfo) {
        return MatchingEntryCountResponseControl.createExactCountResponse(count, examined, true, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createExactCountResponse(int count, boolean examined, boolean searchIndexed, @Nullable Collection<String> debugInfo) {
        return MatchingEntryCountResponseControl.createExactCountResponse(count, examined, searchIndexed, null, null, null, null, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createExactCountResponse(int count, boolean examined, boolean searchIndexed, @Nullable Boolean shortCircuited, @Nullable Boolean fullyIndexed, @Nullable Boolean candidatesAreInScope, @Nullable Filter remainingFilter, @Nullable Collection<String> debugInfo) {
        Validator.ensureTrue(count >= 0);
        MatchingEntryCountType countType = examined ? MatchingEntryCountType.EXAMINED_COUNT : MatchingEntryCountType.UNEXAMINED_COUNT;
        return new MatchingEntryCountResponseControl(countType, count, searchIndexed, shortCircuited, fullyIndexed, candidatesAreInScope, remainingFilter, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createUpperBoundResponse(int upperBound, @Nullable Collection<String> debugInfo) {
        return MatchingEntryCountResponseControl.createUpperBoundResponse(upperBound, true, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createUpperBoundResponse(int upperBound, boolean searchIndexed, @Nullable Collection<String> debugInfo) {
        return MatchingEntryCountResponseControl.createUpperBoundResponse(upperBound, searchIndexed, null, null, null, null, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createUpperBoundResponse(int upperBound, boolean searchIndexed, @Nullable Boolean shortCircuited, @Nullable Boolean fullyIndexed, @Nullable Boolean candidatesAreInScope, @Nullable Filter remainingFilter, @Nullable Collection<String> debugInfo) {
        Validator.ensureTrue(upperBound > 0);
        return new MatchingEntryCountResponseControl(MatchingEntryCountType.UPPER_BOUND, upperBound, searchIndexed, shortCircuited, fullyIndexed, candidatesAreInScope, remainingFilter, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createUnknownCountResponse(@Nullable Collection<String> debugInfo) {
        return new MatchingEntryCountResponseControl(MatchingEntryCountType.UNKNOWN, -1, false, null, null, null, null, debugInfo);
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull MatchingEntryCountType countType, int countValue, boolean searchIndexed, @Nullable Boolean shortCircuited, @Nullable Boolean fullyIndexed, @Nullable Boolean candidatesAreInScope, @Nullable Filter remainingFilter, @Nullable Collection<String> debugInfo) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        switch (countType) {
            case EXAMINED_COUNT: 
            case UNEXAMINED_COUNT: 
            case UPPER_BOUND: {
                elements.add(new ASN1Integer(countType.getBERType(), countValue));
                break;
            }
            case UNKNOWN: {
                elements.add(new ASN1Null(countType.getBERType()));
            }
        }
        if (debugInfo != null) {
            ArrayList<ASN1OctetString> debugElements = new ArrayList<ASN1OctetString>(debugInfo.size());
            for (String s : debugInfo) {
                debugElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-96, debugElements));
        }
        if (!searchIndexed) {
            elements.add(new ASN1Boolean(-127, searchIndexed));
        }
        if (shortCircuited != null) {
            elements.add(new ASN1Boolean(-126, shortCircuited));
        }
        if (fullyIndexed != null) {
            elements.add(new ASN1Boolean(-125, fullyIndexed));
        }
        if (candidatesAreInScope != null) {
            elements.add(new ASN1Boolean(-124, candidatesAreInScope));
        }
        if (remainingFilter != null) {
            elements.add(new ASN1OctetString(-91, remainingFilter.encode().encode()));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public MatchingEntryCountType getCountType() {
        return this.countType;
    }

    public int getCountValue() {
        return this.countValue;
    }

    public boolean searchIndexed() {
        return this.searchIndexed;
    }

    @Nullable
    public Boolean getShortCircuited() {
        return this.shortCircuited;
    }

    @Nullable
    public Boolean getFullyIndexed() {
        return this.fullyIndexed;
    }

    @Nullable
    public Boolean getCandidatesAreInScope() {
        return this.candidatesAreInScope;
    }

    @Nullable
    public Filter getRemainingFilter() {
        return this.remainingFilter;
    }

    @NotNull
    public List<String> getDebugInfo() {
        return this.debugInfo;
    }

    @Override
    @NotNull
    public MatchingEntryCountResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new MatchingEntryCountResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static MatchingEntryCountResponseControl get(@NotNull SearchResult result) throws LDAPException {
        Control c = result.getResponseControl(MATCHING_ENTRY_COUNT_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof MatchingEntryCountResponseControl) {
            return (MatchingEntryCountResponseControl)c;
        }
        return new MatchingEntryCountResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_MATCHING_ENTRY_COUNT_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        switch (this.countType) {
            case EXAMINED_COUNT: {
                valueFields.put(JSON_FIELD_COUNT_TYPE, new JSONString(JSON_COUNT_TYPE_EXAMINED_COUNT));
                valueFields.put(JSON_FIELD_COUNT_VALUE, new JSONNumber(this.countValue));
                break;
            }
            case UNEXAMINED_COUNT: {
                valueFields.put(JSON_FIELD_COUNT_TYPE, new JSONString(JSON_COUNT_TYPE_UNEXAMINED_COUNT));
                valueFields.put(JSON_FIELD_COUNT_VALUE, new JSONNumber(this.countValue));
                break;
            }
            case UPPER_BOUND: {
                valueFields.put(JSON_FIELD_COUNT_TYPE, new JSONString(JSON_COUNT_TYPE_UPPER_BOUND));
                valueFields.put(JSON_FIELD_COUNT_VALUE, new JSONNumber(this.countValue));
                break;
            }
            case UNKNOWN: {
                valueFields.put(JSON_FIELD_COUNT_TYPE, new JSONString(JSON_COUNT_TYPE_UNKNOWN));
            }
        }
        valueFields.put(JSON_FIELD_SEARCH_INDEXED, new JSONBoolean(this.searchIndexed));
        if (this.fullyIndexed != null) {
            valueFields.put(JSON_FIELD_FULLY_INDEXED, new JSONBoolean(this.fullyIndexed));
        }
        if (this.shortCircuited != null) {
            valueFields.put(JSON_FIELD_SHORT_CIRCUITED, new JSONBoolean(this.shortCircuited));
        }
        if (this.candidatesAreInScope != null) {
            valueFields.put(JSON_FIELD_CANDIDATES_ARE_IN_SCOPE, new JSONBoolean(this.candidatesAreInScope));
        }
        if (this.remainingFilter != null) {
            valueFields.put(JSON_FIELD_REMAINING_FILTER, new JSONString(this.remainingFilter.toString()));
        }
        if (this.debugInfo != null && !this.debugInfo.isEmpty()) {
            ArrayList<JSONString> debugInfoValues = new ArrayList<JSONString>(this.debugInfo.size());
            for (String s : this.debugInfo) {
                debugInfoValues.add(new JSONString(s));
            }
            valueFields.put(JSON_FIELD_DEBUG_INFO, new JSONArray(debugInfoValues));
        }
        return new JSONObject(new JSONField("oid", MATCHING_ENTRY_COUNT_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_MATCHING_ENTRY_COUNT_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static MatchingEntryCountResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        ArrayList<String> debugInfo;
        Filter remainingFilter;
        Boolean searchIndexed;
        MatchingEntryCountType countType;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new MatchingEntryCountResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String countTypeStr = valueObject.getFieldAsString(JSON_FIELD_COUNT_TYPE);
        Integer countValue = valueObject.getFieldAsInteger(JSON_FIELD_COUNT_VALUE);
        if (countTypeStr == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_COUNT_TYPE));
        }
        switch (countTypeStr) {
            case "examined-count": {
                countType = MatchingEntryCountType.EXAMINED_COUNT;
                if (countValue != null) break;
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_MISSING_COUNT_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_COUNT_VALUE, JSON_FIELD_COUNT_TYPE, countTypeStr));
            }
            case "unexamined-count": {
                countType = MatchingEntryCountType.UNEXAMINED_COUNT;
                if (countValue != null) break;
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_MISSING_COUNT_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_COUNT_VALUE, JSON_FIELD_COUNT_TYPE, countTypeStr));
            }
            case "upper-bound": {
                countType = MatchingEntryCountType.UPPER_BOUND;
                if (countValue != null) break;
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_MISSING_COUNT_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_COUNT_VALUE, JSON_FIELD_COUNT_TYPE, countTypeStr));
            }
            case "unknown": {
                countType = MatchingEntryCountType.UNKNOWN;
                if (countValue == null) {
                    countValue = -1;
                    break;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_UNEXPECTED_COUNT_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_COUNT_VALUE, JSON_FIELD_COUNT_TYPE, countTypeStr));
            }
            default: {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_UNKNOWN_COUNT_TYPE.get(controlObject.toSingleLineString(), JSON_FIELD_COUNT_TYPE, countTypeStr));
            }
        }
        if ((searchIndexed = valueObject.getFieldAsBoolean(JSON_FIELD_SEARCH_INDEXED)) == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_SEARCH_INDEXED));
        }
        Boolean fullyIndexed = valueObject.getFieldAsBoolean(JSON_FIELD_FULLY_INDEXED);
        Boolean shortCircuited = valueObject.getFieldAsBoolean(JSON_FIELD_SHORT_CIRCUITED);
        Boolean candidatesAreInScope = valueObject.getFieldAsBoolean(JSON_FIELD_CANDIDATES_ARE_IN_SCOPE);
        String remainingFilterStr = valueObject.getFieldAsString(JSON_FIELD_REMAINING_FILTER);
        if (remainingFilterStr == null) {
            remainingFilter = null;
        } else {
            try {
                remainingFilter = Filter.create(remainingFilterStr);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_INVALID_FILTER.get(controlObject.toSingleLineString(), JSON_FIELD_REMAINING_FILTER, remainingFilterStr), e);
            }
        }
        List<JSONValue> debugInfoValues = valueObject.getFieldAsArray(JSON_FIELD_DEBUG_INFO);
        if (debugInfoValues == null) {
            debugInfo = null;
        } else {
            debugInfo = new ArrayList<String>(debugInfoValues.size());
            for (JSONValue v : debugInfoValues) {
                if (v instanceof JSONString) {
                    debugInfo.add(((JSONString)v).stringValue());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_DEBUG_INFO_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_DEBUG_INFO));
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_COUNT_TYPE, JSON_FIELD_COUNT_VALUE, JSON_FIELD_SEARCH_INDEXED, JSON_FIELD_FULLY_INDEXED, JSON_FIELD_SHORT_CIRCUITED, JSON_FIELD_CANDIDATES_ARE_IN_SCOPE, JSON_FIELD_REMAINING_FILTER, JSON_FIELD_DEBUG_INFO)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new MatchingEntryCountResponseControl(countType, countValue, searchIndexed, shortCircuited, fullyIndexed, candidatesAreInScope, remainingFilter, debugInfo);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MatchingEntryCountResponseControl(countType='");
        buffer.append(this.countType.name());
        buffer.append('\'');
        switch (this.countType) {
            case EXAMINED_COUNT: 
            case UNEXAMINED_COUNT: {
                buffer.append(", count=");
                buffer.append(this.countValue);
                break;
            }
            case UPPER_BOUND: {
                buffer.append(", upperBound=");
                buffer.append(this.countValue);
            }
        }
        buffer.append(", searchIndexed=");
        buffer.append(this.searchIndexed);
        if (this.shortCircuited != null) {
            buffer.append(", shortCircuited=");
            buffer.append(this.shortCircuited);
        }
        if (this.fullyIndexed != null) {
            buffer.append(", fullyIndexed=");
            buffer.append(this.fullyIndexed);
        }
        if (this.candidatesAreInScope != null) {
            buffer.append(", candidatesAreInScope=");
            buffer.append(this.candidatesAreInScope);
        }
        if (this.remainingFilter != null) {
            buffer.append(", remainingFilter='");
            this.remainingFilter.toString(buffer);
            buffer.append('\'');
        }
        if (!this.debugInfo.isEmpty()) {
            buffer.append(", debugInfo={");
            Iterator<String> iterator = this.debugInfo.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

