/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.upload;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingInputStream;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.mailbox.model.ContentType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Function0;

public class InMemoryUploadRepository
implements UploadRepository {
    private static final BucketName UPLOAD_BUCKET = BucketName.of((String)"jmap-uploads");
    private final Map<UploadId, ImmutablePair<Username, UploadMetaData>> uploadStore;
    private final BlobId.Factory blobIdFactory;
    private final BlobStoreDAO blobStoreDAO;
    private final BucketName bucketName;
    private final Clock clock;

    @Inject
    public InMemoryUploadRepository(BlobId.Factory blobIdFactory, BlobStoreDAO blobStoreDAO, Clock clock) {
        this.blobIdFactory = blobIdFactory;
        this.blobStoreDAO = blobStoreDAO;
        this.bucketName = UPLOAD_BUCKET;
        this.clock = clock;
        this.uploadStore = new HashMap<UploadId, ImmutablePair<Username, UploadMetaData>>();
    }

    @Override
    public Publisher<UploadMetaData> upload(InputStream data, ContentType contentType, Username user) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)contentType);
        Preconditions.checkNotNull((Object)user);
        UploadId uploadId = UploadId.random();
        BlobId blobId = this.blobIdFactory.of(uploadId.asString());
        return Mono.fromCallable(() -> new CountingInputStream(data)).flatMap(dataAsByte -> Mono.from((Publisher)this.blobStoreDAO.save(this.bucketName, blobId, (InputStream)dataAsByte)).thenReturn(dataAsByte)).map(dataAsByte -> {
            Instant uploadDate = this.clock.instant();
            this.uploadStore.put(uploadId, (ImmutablePair<Username, UploadMetaData>)new ImmutablePair((Object)user, (Object)UploadMetaData.from(uploadId, contentType, dataAsByte.getCount(), blobId, uploadDate)));
            return UploadMetaData.from(uploadId, contentType, dataAsByte.getCount(), blobId, uploadDate);
        });
    }

    @Override
    public Publisher<Upload> retrieve(UploadId id, Username user) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)user);
        return Mono.justOrEmpty(this.uploadStore.get(id)).filter(pair -> user.equals(pair.left)).flatMap(userAndMetaData -> this.retrieveUpload((UploadMetaData)userAndMetaData.right)).switchIfEmpty(Mono.error(() -> new UploadNotFoundException(id)));
    }

    @Override
    public Publisher<Boolean> delete(UploadId id, Username user) {
        return Mono.justOrEmpty(this.uploadStore.get(id)).filter(pair -> user.equals(pair.left)).map(pair -> {
            this.uploadStore.remove(id);
            return true;
        }).defaultIfEmpty((Object)false);
    }

    @Override
    public Publisher<UploadMetaData> listUploads(Username user) {
        return Flux.fromIterable(this.uploadStore.values()).filter(pair -> user.equals(pair.left)).map(pair -> (UploadMetaData)pair.right);
    }

    @Override
    public Publisher<Void> deleteByUploadDateBefore(Duration expireDuration) {
        Instant expirationTime = this.clock.instant().minus(expireDuration);
        return Flux.fromIterable(List.copyOf(this.uploadStore.values())).filter(pair -> ((UploadMetaData)pair.right).uploadDate().isBefore(expirationTime)).flatMap(pair -> Mono.from((Publisher)this.blobStoreDAO.delete(this.bucketName, ((UploadMetaData)pair.right).blobId())).then(Mono.fromRunnable(() -> this.uploadStore.remove(((UploadMetaData)pair.right).uploadId())))).then();
    }

    private Mono<Upload> retrieveUpload(UploadMetaData uploadMetaData) {
        return Mono.from((Publisher)this.blobStoreDAO.readBytes(this.bucketName, uploadMetaData.blobId())).map(content -> Upload.from(uploadMetaData, (Function0<InputStream>)((Function0)() -> new ByteArrayInputStream((byte[])content))));
    }
}

