/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.BaseNCodec;
import com.github.f4b6a3.uuid.codec.base.function.BaseNEncoder;
import java.util.UUID;

public final class BaseNRemainderEncoder
extends BaseNEncoder {
    private final int length;
    private final char padding;
    protected final BaseNCodec.CustomDivider divider;
    private static final long MASK = 0xFFFFFFFFL;

    public BaseNRemainderEncoder(BaseN base) {
        this(base, null);
    }

    public BaseNRemainderEncoder(BaseN base, BaseNCodec.CustomDivider divider) {
        super(base);
        this.length = base.getLength();
        this.padding = base.getPadding();
        long radix = base.getRadix();
        this.divider = divider != null ? divider : x -> new long[]{x / radix, x % radix};
    }

    @Override
    public String apply(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        int b = this.length;
        char[] buffer = new char[this.length];
        long rem = 0L;
        while (msb != 0L || lsb != 0L) {
            rem = 0L;
            long[] ans = BaseNRemainderEncoder.divide(msb, this.divider, rem);
            msb = ans[0];
            rem = ans[1];
            ans = BaseNRemainderEncoder.divide(lsb, this.divider, rem);
            lsb = ans[0];
            rem = ans[1];
            buffer[--b] = this.alphabet.get((int)rem);
        }
        while (b > 0) {
            buffer[--b] = this.padding;
        }
        return new String(buffer);
    }

    protected static long[] divide(long x, BaseNCodec.CustomDivider divider, long rem) {
        long[] div = divider.divide(rem << 32 | x >>> 32);
        long quotient1 = div[0];
        long remainder = div[1];
        div = divider.divide(remainder << 32 | x & 0xFFFFFFFFL);
        long quotient2 = div[0];
        remainder = div[1];
        long[] answer = new long[]{quotient1 << 32 | quotient2 & 0xFFFFFFFFL, remainder};
        return answer;
    }
}

