/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.button;

import com.github.weisj.darklaf.components.button.SplitButtonFallbackUI;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JSplitButton
extends JButton {
    public static final String KEY_ACTION_ADDED = "addedAction";
    public static final String KEY_ACTION_REMOVED = "removedAction";
    private JPopupMenu actionMenu;
    private Icon overlayDropDownIcon;
    private Icon overlayDropDownDisabledIcon;
    private boolean fallbackMode;

    public JSplitButton() {
    }

    public JSplitButton(Icon icon) {
        super(icon);
    }

    public JSplitButton(String text) {
        super(text);
    }

    public JSplitButton(Action a) {
        super(a);
    }

    public JSplitButton(String text, Icon icon) {
        super(text, icon);
    }

    public int getActionCount() {
        return this.listenerList.getListenerCount(ActionListener.class);
    }

    @Override
    public String getUIClassID() {
        return this.fallbackMode ? super.getUIClassID() : "SplitButtonUI";
    }

    @Override
    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
        this.firePropertyChange(KEY_ACTION_ADDED, null, l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
        this.firePropertyChange(KEY_ACTION_REMOVED, l, null);
    }

    public JPopupMenu getActionMenu() {
        if (this.actionMenu == null) {
            this.actionMenu = new JPopupMenu();
        }
        return this.actionMenu;
    }

    public void setActionMenu(JPopupMenu actionMenu) {
        this.actionMenu = actionMenu;
    }

    @Override
    public void updateUI() {
        this.fallbackMode = UIManager.get(this.getUIClassID()) == null;
        super.updateUI();
        if (this.fallbackMode) {
            this.setUI(new SplitButtonFallbackUI(this.getUI()));
        }
        if (this.actionMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.actionMenu);
        }
    }

    public void setOverlayDropDownIcon(Icon overlayDropDownIcon) {
        Icon old = this.overlayDropDownIcon;
        this.overlayDropDownIcon = overlayDropDownIcon;
        this.firePropertyChange("overlayDropDownIcon", old, overlayDropDownIcon);
    }

    public Icon getOverlayDropDownIcon() {
        return this.overlayDropDownIcon;
    }

    public void setOverlayDropDownDisabledIcon(Icon overlayDropDownDisabledIcon) {
        Icon old = this.overlayDropDownDisabledIcon;
        this.overlayDropDownDisabledIcon = overlayDropDownDisabledIcon;
        this.firePropertyChange("overlayDropDownDisabledIcon", old, overlayDropDownDisabledIcon);
    }

    public Icon getOverlayDropDownDisabledIcon() {
        return this.overlayDropDownDisabledIcon;
    }
}

