/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.HLineGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.ArrowSpec;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "animation", "", "getAnimation", "()Ljava/lang/Object;", "setAnimation", "(Ljava/lang/Object;)V", "arrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "getArrowSpec", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "setArrowSpec", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;)V", "flat", "", "getFlat", "()Z", "setFlat", "(Z)V", "geodesic", "getGeodesic", "setGeodesic", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
public final class SegmentGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ArrowSpec arrowSpec;
    @Nullable
    private Object animation;
    private boolean flat;
    private boolean geodesic;
    public static final boolean HANDLES_GROUPS = false;

    @Nullable
    public final ArrowSpec getArrowSpec() {
        return this.arrowSpec;
    }

    public final void setArrowSpec(@Nullable ArrowSpec arrowSpec) {
        this.arrowSpec = arrowSpec;
    }

    @Nullable
    public final Object getAnimation() {
        return this.animation;
    }

    public final void setAnimation(@Nullable Object object) {
        this.animation = object;
    }

    public final boolean getFlat() {
        return this.flat;
    }

    public final void setFlat(boolean bl) {
        this.flat = bl;
    }

    public final boolean getGeodesic() {
        return this.geodesic;
    }

    public final void setGeodesic(boolean bl) {
        this.geodesic = bl;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return HLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx);
        GeomHelper.SvgElementHelper helper2 = new GeomHelper(pos, coord, ctx).createSvgElementHelper();
        helper2.setStrokeAlphaEnabled(true);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.SEGMENT, ctx);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            SvgPathElement arrow;
            if (!SeriesUtil.INSTANCE.allFinite(p.x(), p.y(), p.xend(), p.yend())) continue;
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = p.y();
            Intrinsics.checkNotNull((Object)d3);
            DoubleVector start2 = new DoubleVector(d2, d3.doubleValue());
            Double d4 = p.xend();
            Intrinsics.checkNotNull((Object)d4);
            double d5 = d4;
            Double d6 = p.yend();
            Intrinsics.checkNotNull((Object)d6);
            DoubleVector end = new DoubleVector(d5, d6.doubleValue());
            SvgLineElement line = GeomHelper.SvgElementHelper.createLine$default(helper2, start2, end, p, null, 8, null);
            if (line == null) continue;
            root.add((SvgNode)line);
            Object[] objectArray = new DoubleVector[2];
            Intrinsics.checkNotNull((Object)coord.toClient(start2));
            Intrinsics.checkNotNull((Object)coord.toClient(end));
            GeomTargetCollector.DefaultImpls.addPath$default(targetCollector, CollectionsKt.listOf((Object[])objectArray), (Function1)new Function1<Integer, Integer>(p){
                final /* synthetic */ DataPointAesthetics $p;
                {
                    this.$p = $p;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return this.$p.index();
                }
            }, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)p), 7, null), null, 8, null);
            if (this.arrowSpec == null) continue;
            Object object = line.x1().get();
            Intrinsics.checkNotNull((Object)object);
            double clientX1 = ((Number)object).doubleValue();
            Object object2 = line.y1().get();
            Intrinsics.checkNotNull((Object)object2);
            double clientY1 = ((Number)object2).doubleValue();
            Object object3 = line.x2().get();
            Intrinsics.checkNotNull((Object)object3);
            double clientX2 = ((Number)object3).doubleValue();
            Object object4 = line.y2().get();
            Intrinsics.checkNotNull((Object)object4);
            double clientY2 = ((Number)object4).doubleValue();
            double abscissa = clientX2 - clientX1;
            double ordinate = clientY2 - clientY1;
            if (abscissa == 0.0 && ordinate == 0.0) continue;
            double polarAngle = Math.atan2(ordinate, abscissa);
            ArrowSpec arrowSpec = this.arrowSpec;
            Intrinsics.checkNotNull((Object)arrowSpec);
            DataPointAesthetics arrowAes = arrowSpec.toArrowAes(p);
            ArrowSpec arrowSpec2 = this.arrowSpec;
            Intrinsics.checkNotNull((Object)arrowSpec2);
            if (arrowSpec2.isOnLastEnd()) {
                ArrowSpec arrowSpec3 = this.arrowSpec;
                Intrinsics.checkNotNull((Object)arrowSpec3);
                arrow = arrowSpec3.createElement(polarAngle, clientX2, clientY2);
                GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)arrow, arrowAes, true, null, 8, null);
                root.add((SvgNode)arrow);
            }
            ArrowSpec arrowSpec4 = this.arrowSpec;
            Intrinsics.checkNotNull((Object)arrowSpec4);
            if (!arrowSpec4.isOnFirstEnd()) continue;
            ArrowSpec arrowSpec5 = this.arrowSpec;
            Intrinsics.checkNotNull((Object)arrowSpec5);
            arrow = arrowSpec5.createElement(polarAngle + Math.PI, clientX1, clientY1);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)arrow, arrowAes, true, null, 8, null);
            root.add((SvgNode)arrow);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

