/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimElements;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimGroup;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u00020\u00102$\u0010\u0011\u001a \u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00100\u0012J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J&\u0010\u0016\u001a\u00020\u00102\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u0012J\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u00102\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u001cR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "myAesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "geometryFactory", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lkotlin/jvm/functions/Function1;)V", "createNonLinearRectangles", "", "handler", "Lkotlin/Function3;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "createRectangles", "", "createSlimRectangles", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimGroup;", "iterateRectangleGeometry", "iterator", "Lkotlin/Function2;", "plot-base"})
@SourceDebugExtension(value={"SMAP\nRectanglesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectanglesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1855#2:109\n1855#2,2:111\n1856#2:113\n1855#2,2:114\n1#3:110\n*S KotlinDebug\n*F\n+ 1 RectanglesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper\n*L\n27#1:109\n42#1:111,2\n27#1:113\n52#1:114,2\n*E\n"})
public final class RectanglesHelper
extends GeomHelper {
    @NotNull
    private final Aesthetics myAesthetics;
    @NotNull
    private final Function1<DataPointAesthetics, DoubleRectangle> geometryFactory;

    public RectanglesHelper(@NotNull Aesthetics myAesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx, @NotNull Function1<? super DataPointAesthetics, DoubleRectangle> geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)myAesthetics, (String)"myAesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(geometryFactory, (String)"geometryFactory");
        super(pos, coord, ctx);
        this.myAesthetics = myAesthetics;
        this.geometryFactory = geometryFactory;
    }

    public final void createNonLinearRectangles(@NotNull Function3<? super DataPointAesthetics, ? super SvgNode, ? super List<DoubleVector>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Iterable<DataPointAesthetics> $this$forEach$iv = this.myAesthetics.dataPoints();
        boolean $i$f$forEach = false;
        Iterator<DataPointAesthetics> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            DoubleRectangle rect;
            DataPointAesthetics element$iv;
            DataPointAesthetics p = element$iv = iterator.next();
            boolean bl = false;
            if ((DoubleRectangle)this.geometryFactory.invoke((Object)p) == null) continue;
            boolean bl2 = false;
            AdaptiveResampler.Companion companion = AdaptiveResampler.Companion;
            Object[] objectArray = new DoubleVector[]{new DoubleVector(rect.getLeft(), rect.getTop()), new DoubleVector(rect.getRight(), rect.getTop()), new DoubleVector(rect.getRight(), rect.getBottom()), new DoubleVector(rect.getLeft(), rect.getBottom()), new DoubleVector(rect.getLeft(), rect.getTop())};
            List list2 = CollectionsKt.listOf((Object[])objectArray);
            List polyRect2 = companion.resample(list2, 0.5, (Function1)new Function1<DoubleVector, DoubleVector>(this, p){
                final /* synthetic */ RectanglesHelper this$0;
                final /* synthetic */ DataPointAesthetics $p;
                {
                    this.this$0 = $receiver;
                    this.$p = $p;
                    super(1);
                }

                @Nullable
                public final DoubleVector invoke(@NotNull DoubleVector it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.toClient(it, this.$p);
                }
            });
            SvgPathDataBuilder svgPathData = new SvgPathDataBuilder(false, 1, null);
            DoubleVector p0 = (DoubleVector)CollectionsKt.first((List)polyRect2);
            boolean bl3 = false;
            svgPathData.moveTo(p0);
            Iterable $this$forEach$iv2 = CollectionsKt.drop((Iterable)polyRect2, (int)1);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DoubleVector p02 = (DoubleVector)element$iv2;
                boolean bl4 = false;
                svgPathData.lineTo(p02);
            }
            SvgPathElement svgPoly = new SvgPathElement(svgPathData.build());
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)svgPoly, p, false, null, 12, null);
            handler.invoke((Object)p, (Object)svgPoly, (Object)polyRect2);
        }
    }

    public final void createRectangles(@NotNull Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Iterable<DataPointAesthetics> $this$forEach$iv = this.myAesthetics.dataPoints();
        boolean $i$f$forEach = false;
        Iterator<DataPointAesthetics> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            DoubleRectangle clientRect;
            DoubleRectangle rect;
            DataPointAesthetics element$iv;
            DataPointAesthetics p = element$iv = iterator.next();
            boolean bl = false;
            if ((DoubleRectangle)this.geometryFactory.invoke((Object)p) == null) continue;
            boolean bl2 = false;
            if (this.toClient(rect, p) == null) continue;
            SvgRectElement svgRect = new SvgRectElement(clientRect);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)svgRect, p, false, null, 12, null);
            handler.invoke((Object)p, (Object)svgRect, (Object)clientRect);
        }
    }

    @NotNull
    public final List<SvgNode> createRectangles() {
        ArrayList<SvgRectElement> result = new ArrayList<SvgRectElement>();
        int n = this.myAesthetics.dataPointCount();
        for (int index = 0; index < n; ++index) {
            DoubleRectangle clientRect;
            DataPointAesthetics p = this.myAesthetics.dataPointAt(index);
            if ((DoubleRectangle)this.geometryFactory.invoke((Object)p) == null) continue;
            SvgRectElement svgRect = new SvgRectElement(clientRect);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)svgRect, p, false, null, 12, null);
            result.add(svgRect);
        }
        return result;
    }

    public final void iterateRectangleGeometry(@NotNull Function2<? super DataPointAesthetics, ? super DoubleRectangle, Unit> iterator) {
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        int n = this.myAesthetics.dataPointCount();
        for (int index = 0; index < n; ++index) {
            DoubleRectangle rect;
            DataPointAesthetics p = this.myAesthetics.dataPointAt(index);
            if ((DoubleRectangle)this.geometryFactory.invoke((Object)p) == null) continue;
            boolean bl = false;
            iterator.invoke((Object)p, (Object)rect);
        }
    }

    @NotNull
    public final SvgSlimGroup createSlimRectangles() {
        int pointCount = this.myAesthetics.dataPointCount();
        SvgSlimGroup group = SvgSlimElements.INSTANCE.g(pointCount);
        for (int index = 0; index < pointCount; ++index) {
            DoubleRectangle clientRect;
            DataPointAesthetics p = this.myAesthetics.dataPointAt(index);
            if ((DoubleRectangle)this.geometryFactory.invoke((Object)p) == null) continue;
            SvgSlimShape slimShape = SvgSlimElements.INSTANCE.rect(clientRect.getLeft(), clientRect.getTop(), clientRect.getWidth(), clientRect.getHeight());
            GeomHelper.Companion.decorateSlimShape$plot_base$default(GeomHelper.Companion, slimShape, p, false, 4, null);
            slimShape.appendTo(group);
        }
        return group;
    }
}

