/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.commands.info.InfoProvider;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Command(scope="shell", name="info", description="Prints system information.")
@Service
public class InfoAction
implements Action {
    private NumberFormat fmtI = new DecimalFormat("###,###", new DecimalFormatSymbols(Locale.ENGLISH));
    private NumberFormat fmtD = new DecimalFormat("###,##0.000", new DecimalFormatSymbols(Locale.ENGLISH));
    List<InfoProvider> infoProviders;

    public Object execute() throws Exception {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        int maxNameLen = 25;
        System.out.println("Karaf");
        this.printValue("Karaf version", maxNameLen, System.getProperty("karaf.version"));
        this.printValue("Karaf home", maxNameLen, System.getProperty("karaf.home"));
        this.printValue("Karaf base", maxNameLen, System.getProperty("karaf.base"));
        String osgi = this.getOsgiFramework();
        if (osgi != null) {
            this.printValue("OSGi Framework", maxNameLen, osgi);
        }
        System.out.println();
        System.out.println("JVM");
        this.printValue("Java Virtual Machine", maxNameLen, runtime.getVmName() + " version " + runtime.getVmVersion());
        this.printValue("Version", maxNameLen, System.getProperty("java.version"));
        this.printValue("Vendor", maxNameLen, runtime.getVmVendor());
        this.printValue("Pid", maxNameLen, this.getPid());
        this.printValue("Uptime", maxNameLen, this.printDuration(runtime.getUptime()));
        try {
            this.printValue("Process CPU time", maxNameLen, this.printDuration(this.getSunOsValueAsLong(os, "getProcessCpuTime") / 1000000L));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.printValue("Total compile time", maxNameLen, this.printDuration(ManagementFactory.getCompilationMXBean().getTotalCompilationTime()));
        System.out.println("Threads");
        this.printValue("Live threads", maxNameLen, Integer.toString(threads.getThreadCount()));
        this.printValue("Daemon threads", maxNameLen, Integer.toString(threads.getDaemonThreadCount()));
        this.printValue("Peak", maxNameLen, Integer.toString(threads.getPeakThreadCount()));
        this.printValue("Total started", maxNameLen, Long.toString(threads.getTotalStartedThreadCount()));
        System.out.println("Memory");
        this.printValue("Current heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getUsed()));
        this.printValue("Maximum heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getMax()));
        this.printValue("Committed heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getCommitted()));
        this.printValue("Pending objects", maxNameLen, Integer.toString(mem.getObjectPendingFinalizationCount()));
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            String val = "Name = '" + garbageCollectorMXBean.getName() + "', Collections = " + garbageCollectorMXBean.getCollectionCount() + ", Time = " + this.printDuration(garbageCollectorMXBean.getCollectionTime());
            this.printValue("Garbage collector", maxNameLen, val);
        }
        System.out.println("Classes");
        this.printValue("Current classes loaded", maxNameLen, this.printLong(cl.getLoadedClassCount()));
        this.printValue("Total classes loaded", maxNameLen, this.printLong(cl.getTotalLoadedClassCount()));
        this.printValue("Total classes unloaded", maxNameLen, this.printLong(cl.getUnloadedClassCount()));
        System.out.println("Operating system");
        this.printValue("Name", maxNameLen, os.getName() + " version " + os.getVersion());
        this.printValue("Architecture", maxNameLen, os.getArch());
        this.printValue("Processors", maxNameLen, Integer.toString(os.getAvailableProcessors()));
        try {
            this.printValue("Total physical memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getTotalPhysicalMemorySize")));
            this.printValue("Free physical memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getFreePhysicalMemorySize")));
            this.printValue("Committed virtual memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getCommittedVirtualMemorySize")));
            this.printValue("Total swap space", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getTotalSwapSpaceSize")));
            this.printValue("Free swap space", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getFreeSwapSpaceSize")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HashMap<String, Properties> properties = new HashMap<String, Properties>();
        if (this.infoProviders != null) {
            for (InfoProvider provider : this.infoProviders) {
                if (!properties.containsKey(provider.getName())) {
                    properties.put(provider.getName(), new Properties());
                }
                ((Map)properties.get(provider.getName())).putAll(provider.getProperties());
            }
            ArrayList arrayList = new ArrayList(properties.keySet());
            Collections.sort(arrayList);
            for (String section : arrayList) {
                ArrayList keys = new ArrayList(((Map)properties.get(section)).keySet());
                if (keys.size() <= 0) continue;
                System.out.println(section);
                Collections.sort(keys, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return String.valueOf(o1).compareTo(String.valueOf(o2));
                    }
                });
                for (Object key : keys) {
                    this.printValue(String.valueOf(key), maxNameLen, String.valueOf(((Map)properties.get(section)).get(key)));
                }
            }
        }
        return null;
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] parts = name.split("@");
        return parts[0];
    }

    private long getSunOsValueAsLong(OperatingSystemMXBean os, String name) throws Exception {
        Method mth = os.getClass().getMethod(name, new Class[0]);
        return (Long)mth.invoke((Object)os, new Object[0]);
    }

    private String printLong(long i) {
        return this.fmtI.format(i);
    }

    private String printSizeInKb(double size) {
        return this.fmtI.format((long)(size / 1024.0)) + " kbytes";
    }

    protected String printDuration(double uptime) {
        if ((uptime /= 1000.0) < 60.0) {
            return this.fmtD.format(uptime) + " seconds";
        }
        if ((uptime /= 60.0) < 60.0) {
            long minutes = (long)uptime;
            String s = this.fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            return s;
        }
        if ((uptime /= 60.0) < 24.0) {
            long hours = (long)uptime;
            long minutes = (long)((uptime - (double)hours) * 60.0);
            String s = this.fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
            if (minutes != 0L) {
                s = s + " " + this.fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            }
            return s;
        }
        long days = (long)(uptime /= 24.0);
        long hours = (long)((uptime - (double)days) * 24.0);
        String s = this.fmtI.format(days) + (days > 1L ? " days" : " day");
        if (hours != 0L) {
            s = s + " " + this.fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
        }
        return s;
    }

    void printSysValue(String prop, int pad) {
        this.printValue(prop, pad, System.getProperty(prop));
    }

    void printValue(String name, int pad, String value) {
        System.out.println(Ansi.ansi().a("  ").a(Ansi.Attribute.INTENSITY_BOLD).a(name).a(this.spaces(pad - name.length())).a(Ansi.Attribute.RESET).a("   ").a(value).toString());
    }

    String spaces(int nb) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nb; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    String getOsgiFramework() {
        try {
            Callable<String> call = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                    Bundle sysBundle = context.getBundle(0L);
                    return sysBundle.getSymbolicName() + "-" + sysBundle.getVersion();
                }
            };
            return (String)call.call();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

