/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.impl.jline;

import java.nio.charset.Charset;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.shell.console.Console;
import org.apache.karaf.shell.console.factory.ConsoleFactory;
import org.apache.karaf.shell.console.impl.jline.DelayedStarted;
import org.apache.karaf.shell.console.impl.jline.StreamWrapUtil;
import org.apache.karaf.shell.console.impl.jline.TerminalFactory;
import org.apache.karaf.shell.util.ShellUtil;
import org.apache.karaf.util.jaas.JaasHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class LocalConsoleManager {
    private ConsoleFactory consoleFactory;
    private BundleContext bundleContext;
    private TerminalFactory terminalFactory;
    private Console console;
    private boolean start;
    private final int defaultStartLevel;
    private ServiceRegistration<?> registration;

    public LocalConsoleManager(boolean start, String defaultStartLevel, BundleContext bundleContext, TerminalFactory terminalFactory, ConsoleFactory consoleFactory) throws Exception {
        this.start = start;
        this.defaultStartLevel = Integer.parseInt(defaultStartLevel);
        this.bundleContext = bundleContext;
        this.terminalFactory = terminalFactory;
        this.consoleFactory = consoleFactory;
        this.start();
    }

    public void start() throws Exception {
        if (!this.start) {
            return;
        }
        final Terminal terminal = this.terminalFactory.getTerminal();
        final Runnable callback = new Runnable(){

            @Override
            public void run() {
                try {
                    LocalConsoleManager.this.bundleContext.getBundle(0L).stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Subject subject = this.createLocalKarafSubject();
        this.console = JaasHelper.doAs(subject, new PrivilegedAction<Console>(){

            @Override
            public Console run() {
                String encoding = LocalConsoleManager.getEncoding();
                LocalConsoleManager.this.console = LocalConsoleManager.this.consoleFactory.create(StreamWrapUtil.reWrapIn(terminal, System.in), StreamWrapUtil.reWrap(System.out), StreamWrapUtil.reWrap(System.err), terminal, encoding, callback);
                String name = "Karaf local console user " + ShellUtil.getCurrentUserName();
                boolean delayconsole = Boolean.parseBoolean(System.getProperty("karaf.delay.console"));
                if (delayconsole) {
                    DelayedStarted watcher = new DelayedStarted(LocalConsoleManager.this.console, name, LocalConsoleManager.this.bundleContext, System.in);
                    new Thread(watcher).start();
                } else {
                    new Thread((Runnable)LocalConsoleManager.this.console, name).start();
                }
                return LocalConsoleManager.this.console;
            }
        });
        this.registration = this.bundleContext.registerService(CommandSession.class, (Object)this.console.getSession(), null);
    }

    public static String getEncoding() {
        String envEncoding = LocalConsoleManager.extractEncodingFromCtype(System.getenv("LC_CTYPE"));
        if (envEncoding != null) {
            return envEncoding;
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String ctype) {
        if (ctype != null && ctype.indexOf(46) > 0) {
            String encodingAndModifier = ctype.substring(ctype.indexOf(46) + 1);
            if (encodingAndModifier.indexOf(64) > 0) {
                return encodingAndModifier.substring(0, encodingAndModifier.indexOf(64));
            }
            return encodingAndModifier;
        }
        return null;
    }

    private Subject createLocalKarafSubject() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UserPrincipal("karaf"));
        String roles = System.getProperty("karaf.local.roles");
        if (roles != null) {
            for (String role : roles.split("[,]")) {
                subject.getPrincipals().add((Principal)new RolePrincipal(role.trim()));
            }
        }
        return subject;
    }

    public void stop() throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.console != null) {
            this.console.close(false);
        }
    }
}

