/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.util.StreamUtils;

@Command(scope="config", name="install", description="Install a cfg file in the Karaf etc folder.")
@Service
public class InstallCommand
implements Action {
    @Argument(index=0, name="url", description="The URL of the cfg file.", required=true, multiValued=false)
    private String url;
    @Argument(index=1, name="finalname", description="Final name of the cfg file", required=true, multiValued=false)
    private String finalname;
    @Option(name="-o", aliases={"--override"}, description="Override the target cfg file", required=false, multiValued=false)
    private boolean override;

    public Object execute() throws Exception {
        File etcFolder = new File(System.getProperty("karaf.etc"));
        File file = new File(etcFolder, this.finalname);
        if (file.exists()) {
            if (!this.override) {
                throw new IllegalArgumentException("Configuration file {} already exists " + this.finalname);
            }
            System.out.println("Overriding configuration file " + this.finalname);
        } else {
            System.out.println("Creating configuration file " + this.finalname);
        }
        try (BufferedInputStream is = new BufferedInputStream(new URL(this.url).openStream());){
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
            }
            try (FileOutputStream fop = new FileOutputStream(file);){
                StreamUtils.copy(is, fop);
            }
        }
        return null;
    }
}

