/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml.util.jsse;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.core.xml.util.jsse.AbstractBaseSSLContextParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractKeyManagersParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractSSLContextClientParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractSSLContextServerParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractSecureRandomParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractTrustManagersParametersFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.jsse.SSLContextClientParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.SSLContextServerParameters;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlTransient
public abstract class AbstractSSLContextParametersFactoryBean
extends AbstractBaseSSLContextParametersFactoryBean<SSLContextParameters> {
    @XmlAttribute
    @Metadata(description="The optional provider identifier for the JSSE implementation to use when constructing an SSLContext.")
    private String provider;
    @XmlAttribute
    @Metadata(description="The optional protocol for the secure sockets created by the SSLContext represented by this instance's configuration. See Appendix A in the Java Secure Socket Extension Reference Guide for information about standard protocol names.")
    private String secureSocketProtocol;
    @XmlAttribute
    @Metadata(description="An optional certificate alias to use. This is useful when the keystore has multiple certificates.")
    private String certAlias;

    @Override
    protected SSLContextParameters createInstance() throws Exception {
        SSLContextParameters newInstance = new SSLContextParameters();
        if (this.getKeyManagers() != null) {
            this.getKeyManagers().setCamelContext(this.getCamelContext());
            newInstance.setKeyManagers(this.getKeyManagers().getObject());
        }
        if (this.getTrustManagers() != null) {
            this.getTrustManagers().setCamelContext(this.getCamelContext());
            newInstance.setTrustManagers(this.getTrustManagers().getObject());
        }
        if (this.getSecureRandom() != null) {
            this.getSecureRandom().setCamelContext(this.getCamelContext());
            newInstance.setSecureRandom(this.getSecureRandom().getObject());
        }
        if (this.getClientParameters() != null) {
            this.getClientParameters().setCamelContext(this.getCamelContext());
            newInstance.setClientParameters((SSLContextClientParameters)this.getClientParameters().getObject());
        }
        if (this.getServerParameters() != null) {
            this.getServerParameters().setCamelContext(this.getCamelContext());
            newInstance.setServerParameters((SSLContextServerParameters)this.getServerParameters().getObject());
        }
        newInstance.setProvider(this.provider);
        newInstance.setSecureSocketProtocol(this.secureSocketProtocol);
        newInstance.setCertAlias(this.certAlias);
        newInstance.setCamelContext(this.getCamelContext());
        return newInstance;
    }

    @Override
    public Class<? extends SSLContextParameters> getObjectType() {
        return SSLContextParameters.class;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    public void setSecureSocketProtocol(String secureSocketProtocol) {
        this.secureSocketProtocol = secureSocketProtocol;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    protected abstract AbstractKeyManagersParametersFactoryBean getKeyManagers();

    protected abstract AbstractTrustManagersParametersFactoryBean getTrustManagers();

    protected abstract AbstractSecureRandomParametersFactoryBean getSecureRandom();

    protected abstract AbstractSSLContextClientParametersFactoryBean getClientParameters();

    protected abstract AbstractSSLContextServerParametersFactoryBean getServerParameters();
}

