/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Predicate;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="error")
@XmlRootElement(name="doTry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TryDefinition
extends OutputDefinition<TryDefinition> {
    @XmlTransient
    private List<CatchDefinition> catchClauses;
    @XmlTransient
    private FinallyDefinition finallyClause;
    @XmlTransient
    private boolean initialized;
    @XmlTransient
    private List<ProcessorDefinition<?>> outputsWithoutCatches;

    @Override
    public String toString() {
        return "DoTry[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "doTry";
    }

    @Override
    public String getLabel() {
        return "doTry";
    }

    public TryDefinition doCatch(Class<? extends Throwable> exceptionType) {
        return this.doCatch(new Class[]{exceptionType});
    }

    @SafeVarargs
    public final TryDefinition doCatch(Class<? extends Throwable> ... exceptionType) {
        this.popBlock();
        List<Class<? extends Throwable>> list = Arrays.asList(exceptionType);
        CatchDefinition answer = new CatchDefinition(list);
        this.addOutput(answer);
        this.pushBlock(answer);
        return this;
    }

    public TryDefinition doFinally() {
        this.popBlock();
        FinallyDefinition answer = new FinallyDefinition();
        this.addOutput(answer);
        this.pushBlock(answer);
        return this;
    }

    public TryDefinition onWhen(@AsPredicate Predicate predicate) {
        Iterator<CatchDefinition> it = ProcessorDefinitionHelper.filterTypeInOutputs(this.getOutputs(), CatchDefinition.class);
        while (it.hasNext()) {
            CatchDefinition doCatch = it.next();
            doCatch.setOnWhen(new WhenDefinition(predicate));
        }
        return this;
    }

    public List<CatchDefinition> getCatchClauses() {
        if (this.catchClauses == null) {
            this.checkInitialized();
        }
        return this.catchClauses;
    }

    public FinallyDefinition getFinallyClause() {
        if (this.finallyClause == null) {
            this.checkInitialized();
        }
        return this.finallyClause;
    }

    public List<ProcessorDefinition<?>> getOutputsWithoutCatches() {
        if (this.outputsWithoutCatches == null) {
            this.checkInitialized();
        }
        return this.outputsWithoutCatches;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return super.getOutputs();
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.initialized = false;
        super.setOutputs(outputs);
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        this.initialized = false;
        super.addOutput(output);
    }

    @Override
    public void preCreateProcessor() {
        this.initialized = false;
        this.checkInitialized();
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            this.initialized = true;
            this.outputsWithoutCatches = new ArrayList();
            this.catchClauses = new ArrayList<CatchDefinition>();
            this.finallyClause = null;
            for (ProcessorDefinition output : this.outputs) {
                if (output instanceof CatchDefinition) {
                    this.catchClauses.add((CatchDefinition)output);
                    continue;
                }
                if (output instanceof FinallyDefinition) {
                    if (this.finallyClause != null) {
                        throw new IllegalArgumentException("Multiple finally clauses added: " + this.finallyClause + " and " + output);
                    }
                    this.finallyClause = (FinallyDefinition)output;
                    continue;
                }
                this.outputsWithoutCatches.add(output);
            }
        }
    }
}

