/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.exporter;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.changelog.ChangelogEntry;
import org.apache.logging.log4j.changelog.ChangelogFiles;
import org.apache.logging.log4j.changelog.ChangelogRelease;
import org.apache.logging.log4j.changelog.exporter.ChangelogExporterArgs;
import org.apache.logging.log4j.changelog.exporter.ChangelogExporterTemplate;
import org.apache.logging.log4j.changelog.util.FileUtils;
import org.apache.logging.log4j.tools.internal.freemarker.util.FreeMarkerUtils;

public final class ChangelogExporter {
    private ChangelogExporter() {
    }

    public static void performExport(ChangelogExporterArgs args) {
        List<Path> releaseDirectories = ChangelogExporter.findReleaseDirectories(args);
        int releaseDirectoryCount = releaseDirectories.size();
        List<ChangelogRelease> changelogReleases = releaseDirectories.stream().map(releaseDirectory -> {
            Path releaseXmlFile = ChangelogFiles.releaseXmlFile(releaseDirectory);
            return ChangelogRelease.readFromXmlFile(releaseXmlFile);
        }).collect(Collectors.toList());
        List<Integer> changelogEntryCounts = releaseDirectories.stream().map(ignored -> 0).collect(Collectors.toList());
        if (releaseDirectoryCount > 0) {
            for (int releaseIndex = 0; releaseIndex < releaseDirectories.size(); ++releaseIndex) {
                int changelogEntryCount;
                Path releaseDirectory2 = releaseDirectories.get(releaseIndex);
                ChangelogRelease changelogRelease = (ChangelogRelease)changelogReleases.get(releaseIndex);
                try {
                    changelogEntryCount = ChangelogExporter.exportRelease(args.outputDirectory, args.changelogDirectory, releaseDirectory2, changelogRelease, args.changelogTemplates);
                }
                catch (Exception error) {
                    String message = String.format("failed exporting release from directory `%s`", releaseDirectory2);
                    throw new RuntimeException(message, error);
                }
                changelogEntryCounts.set(releaseIndex, changelogEntryCount);
            }
            if (releaseDirectoryCount == 1) {
                System.out.format("exported a single release directory: `%s`%n", releaseDirectories.get(0));
            } else {
                System.out.format("exported %d release directories: ..., `%s`%n", releaseDirectories.size(), releaseDirectories.get(releaseDirectoryCount - 1));
            }
        }
        ChangelogFiles.unreleasedDirectoryVersionMajors(args.changelogDirectory).stream().sorted().forEach(upcomingReleaseVersionMajor -> {
            Path upcomingReleaseDirectory = ChangelogFiles.unreleasedDirectory(args.changelogDirectory, upcomingReleaseVersionMajor);
            ChangelogRelease upcomingRelease = ChangelogExporter.upcomingRelease(upcomingReleaseVersionMajor);
            System.out.format("exporting upcoming release directory: `%s`%n", upcomingReleaseDirectory);
            int changelogEntryCount = ChangelogExporter.exportRelease(args.outputDirectory, args.changelogDirectory, upcomingReleaseDirectory, upcomingRelease, args.changelogTemplates);
            changelogReleases.add(upcomingRelease);
            changelogEntryCounts.add(changelogEntryCount);
        });
        ChangelogExporter.exportIndex(args.outputDirectory, args.changelogDirectory, args.indexTemplates, changelogReleases, changelogEntryCounts);
    }

    private static List<Path> findReleaseDirectories(ChangelogExporterArgs args) {
        return FileUtils.findAdjacentFiles(args.changelogDirectory, true, paths -> paths.filter(ChangelogExporter::isNonEmptyDirectory).sorted(Comparator.comparing(releaseDirectory -> {
            Path releaseXmlFile = ChangelogFiles.releaseXmlFile(releaseDirectory);
            ChangelogRelease changelogRelease = ChangelogRelease.readFromXmlFile(releaseXmlFile);
            return changelogRelease.date;
        })).collect(Collectors.toList()));
    }

    private static boolean isNonEmptyDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) && FileUtils.findAdjacentFiles(path, false, paths -> paths.findFirst().isPresent()) != false;
    }

    private static int exportRelease(Path outputDirectory, Path changelogDirectory, Path releaseDirectory, ChangelogRelease changelogRelease, Set<ChangelogExporterTemplate> changelogTemplates) {
        Map<ChangelogEntry.Type, List<ChangelogEntry>> changelogEntriesByType = ChangelogExporter.readChangelogEntriesByType(releaseDirectory);
        try {
            ChangelogExporter.exportRelease(outputDirectory, changelogDirectory, releaseDirectory, changelogRelease, changelogEntriesByType, changelogTemplates);
        }
        catch (Exception error) {
            String message = String.format("failed exporting release from directory `%s`", releaseDirectory);
            throw new RuntimeException(message, error);
        }
        return changelogEntriesByType.values().stream().mapToInt(Collection::size).sum();
    }

    private static Map<ChangelogEntry.Type, List<ChangelogEntry>> readChangelogEntriesByType(Path releaseDirectory) {
        return FileUtils.findAdjacentFiles(releaseDirectory, true, stream -> stream.sorted().map(ChangelogEntry::readFromXmlFile).collect(Collectors.groupingBy(changelogEntry -> changelogEntry.type, TreeMap::new, Collectors.toList())));
    }

    private static void exportRelease(Path outputDirectory, Path changelogDirectory, Path releaseDirectory, ChangelogRelease release, Map<ChangelogEntry.Type, List<ChangelogEntry>> entriesByType, Set<ChangelogExporterTemplate> changelogTemplates) {
        LinkedHashMap<String, Object> changelogTemplateData = new LinkedHashMap<String, Object>();
        changelogTemplateData.put("release", release);
        changelogTemplateData.put("entriesByType", entriesByType);
        for (ChangelogExporterTemplate changelogTemplate : changelogTemplates) {
            Path changelogTemplateSourceFile = releaseDirectory.resolve(changelogTemplate.sourceFileName);
            if (Files.exists(changelogTemplateSourceFile, new LinkOption[0])) {
                String changelogTemplateName = ChangelogExporter.templateName(changelogDirectory, changelogTemplateSourceFile);
                String changelogTemplateTargetFileName = changelogTemplate.targetFileName.replaceAll("%v", release.version);
                Path changelogTemplateTargetFile = outputDirectory.resolve(changelogTemplateTargetFileName);
                FreeMarkerUtils.render((Path)changelogDirectory, (String)changelogTemplateName, changelogTemplateData, (Path)changelogTemplateTargetFile);
                continue;
            }
            if (!changelogTemplate.failIfNotFound) continue;
            String message = String.format("could not find template file: `%s`", changelogTemplateSourceFile);
            throw new IllegalStateException(message);
        }
    }

    private static ChangelogRelease upcomingRelease(int versionMajor) {
        String releaseVersion = versionMajor + ".x.x";
        return new ChangelogRelease(releaseVersion, null);
    }

    private static void exportIndex(Path outputDirectory, Path changelogDirectory, Set<ChangelogExporterTemplate> indexTemplates, List<ChangelogRelease> changelogReleases, List<Integer> changelogEntryCounts) {
        Map indexTemplateData = Collections.singletonMap("releases", IntStream.range(0, changelogReleases.size()).boxed().sorted(Comparator.reverseOrder()).map(releaseIndex -> {
            ChangelogRelease changelogRelease = (ChangelogRelease)changelogReleases.get((int)releaseIndex);
            int changelogEntryCount = (Integer)changelogEntryCounts.get((int)releaseIndex);
            LinkedHashMap<String, Object> changelogReleaseData = new LinkedHashMap<String, Object>();
            changelogReleaseData.put("version", changelogRelease.version);
            changelogReleaseData.put("date", changelogRelease.date);
            changelogReleaseData.put("changelogEntryCount", changelogEntryCount);
            return changelogReleaseData;
        }).collect(Collectors.toList()));
        indexTemplates.forEach(indexTemplate -> {
            Path indexTemplateSourceFile = changelogDirectory.resolve(indexTemplate.sourceFileName);
            if (Files.exists(indexTemplateSourceFile, new LinkOption[0])) {
                String indexTemplateSourceName = ChangelogExporter.templateName(changelogDirectory, indexTemplateSourceFile);
                Path indexTemplateTargetFile = outputDirectory.resolve(indexTemplate.targetFileName);
                FreeMarkerUtils.render((Path)changelogDirectory, (String)indexTemplateSourceName, (Object)indexTemplateData, (Path)indexTemplateTargetFile);
            } else if (indexTemplate.failIfNotFound) {
                String message = String.format("could not find template file: `%s`", indexTemplateSourceFile);
                throw new IllegalStateException(message);
            }
        });
    }

    private static String templateName(Path changelogDirectory, Path path) {
        Path relativePath = changelogDirectory.relativize(path);
        return File.pathSeparatorChar == '/' ? relativePath.toString() : relativePath.toString().replace('\\', '/');
    }
}

